/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.VerificationConverter;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodVerification;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class LocalMethodDescriptor
implements MethodDescriptor {
    static final String CONTROL_TASK_DISPATCH_METHOD = "controlTaskDispatch";
    private static final Set<String> RESERVED_ATTRIBUTE_NAMES = Sets.newHashSet((Object[])new String[]{"name", "label", "description", "parameters-type"});
    private String name;
    private String label;
    private String description;
    private String delegate;
    private Map<String, String> attributes = Maps.newHashMap();
    private Descriptor descriptor;
    private List<MethodVerification> verifications = Lists.newArrayList();
    private Type parameterType;

    private LocalMethodDescriptor(Descriptor descriptor, String name) {
        this.descriptor = descriptor;
        this.name = name;
    }

    private LocalMethodDescriptor(Descriptor descriptor, Method method) {
        this.name = method.getName();
        this.delegate = "methodInvoker";
        this.descriptor = descriptor;
    }

    LocalMethodDescriptor(LocalMethodDescriptor copyOf, Descriptor newOwner) {
        this.name = copyOf.name;
        this.description = copyOf.description;
        this.label = copyOf.label;
        this.attributes = copyOf.attributes;
        this.delegate = copyOf.delegate;
        this.parameterType = copyOf.parameterType;
        this.descriptor = newOwner;
    }

    static MethodDescriptor from(Descriptor descriptor, Method method) {
        LocalMethodDescriptor methodDescriptor = new LocalMethodDescriptor(descriptor, method);
        methodDescriptor.initMetadata(method);
        LocalMethodDescriptor.initVerifications(methodDescriptor);
        return methodDescriptor;
    }

    static MethodDescriptor from(Descriptor descriptor, Element element) {
        String name = XmlUtils.getRequiredStringAttribute(element, "name");
        LocalMethodDescriptor methodDescriptor = new LocalMethodDescriptor(descriptor, name);
        methodDescriptor.label = XmlUtils.getOptionalStringAttribute(element, "label", name);
        methodDescriptor.description = XmlUtils.getOptionalStringAttribute(element, "description", "No description.");
        methodDescriptor.delegate = XmlUtils.getOptionalStringAttribute(element, "delegate", "dispatcherInvoker");
        if (element.hasAttribute("parameters-type")) {
            methodDescriptor.parameterType = XmlUtils.getOptionalTypeAttribute(element, "parameters-type");
        } else {
            Iterator<Element> parameters = XmlUtils.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"parameters"));
            if (parameters.hasNext()) {
                methodDescriptor.parameterType = TypeDefinitions.generatedParameterType(descriptor.getType(), name);
            }
        }
        methodDescriptor.attributes = LocalMethodDescriptor.readAttributes(element);
        LocalMethodDescriptor.initVerifications(methodDescriptor);
        return methodDescriptor;
    }

    private static void initVerifications(LocalMethodDescriptor methodDescriptor) {
        Method delegateMethod = (Method)Preconditions.checkNotNull((Object)DelegateRegistry.getDelegate(methodDescriptor.delegate), (Object)(methodDescriptor.delegate + " is referenced, but not registered."));
        for (Annotation annotation : delegateMethod.getAnnotations()) {
            if (!VerificationConverter.isVerification(annotation)) continue;
            methodDescriptor.verifications.add((MethodVerification)VerificationConverter.makeVerification(annotation));
        }
    }

    private static Map<String, String> readAttributes(Element element) {
        HashMap map = Maps.newHashMap();
        NamedNodeMap xmlAttrs = element.getAttributes();
        for (int i = 0; i < xmlAttrs.getLength(); ++i) {
            Attr item = (Attr)xmlAttrs.item(i);
            if (RESERVED_ATTRIBUTE_NAMES.contains(item.getName())) continue;
            map.put(item.getName(), item.getValue());
        }
        return map;
    }

    private void initMetadata(Method method) {
        ControlTask annotation = method.getAnnotation(ControlTask.class);
        this.description = annotation.description();
        this.label = annotation.label().equals("") ? this.name : annotation.label();
        this.parameterType = annotation.parameterType().equals("") ? this.parameterType : Type.valueOf((String)annotation.parameterType());
    }

    void verify(final Verifications verifications) {
        verifications.verify(this.descriptor.getType(), DelegateRegistry.exists(this.delegate), "No delegate called [%s] available for control task [%s]", this.delegate, this.getFqn());
        Type superType = Type.valueOf(Parameters.class);
        verifications.verify(this.parameterType == null || this.parameterType.isSubTypeOf(superType), "The parameter type [%s] for control task [%s] should be a subtype of [%s]", this.parameterType, this.getFqn(), superType);
        for (MethodVerification verification : this.verifications) {
            verification.verify((MethodDescriptor)this, new VerificationContext(){

                public void error(String message, Object ... params) {
                    verifications.verify(LocalMethodDescriptor.this.descriptor.getType(), false, message, params);
                }
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Type getParameterObjectType() {
        return this.parameterType;
    }

    public <T> T invoke(ConfigurationItem item) {
        return this.invokeDelegate(item, null);
    }

    public <T> T invoke(ConfigurationItem item, Parameters params) {
        return this.invokeDelegate(item, params);
    }

    private <T> T invokeDelegate(ConfigurationItem item, Parameters params) {
        Method method = DelegateRegistry.getDelegate(this.delegate);
        Object o = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            Deprecations.deprecated((String)"**Deprecated** Non-static delegates are deprecated (Found while invoking [%s]).", (Object[])new Object[]{this.getFqn()});
            o = DelegateRegistry.instantiateDelegate(this.delegate);
        }
        try {
            if (method.getParameterTypes().length == 3) {
                return (T)method.invoke(o, item, this.name, this.attributes);
            }
            return (T)method.invoke(o, item, this.name, this.attributes, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + this.name + " on " + item, e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + this.name + " on " + item);
        }
    }

    public String getFqn() {
        return String.format("%s.%s", this.descriptor.getType(), this.name);
    }
}

