/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class Relayer {
    protected ConcurrentMap<String, List<Route>> routes = new ConcurrentHashMap<String, List<Route>>(5);
    protected final Queue<Bridge> bridges = new ConcurrentLinkedQueue<Bridge>();
    protected final Log log;
    protected final RELAY2 relay;
    protected volatile boolean done;
    protected boolean stats;

    public Relayer(RELAY2 relay, Log log) {
        this.relay = relay;
        this.stats = relay.statsEnabled();
        this.log = log;
    }

    public boolean done() {
        return this.done;
    }

    public void start(List<RelayConfig.BridgeConfig> bridge_configs, String bridge_name, final String my_site_id) throws Throwable {
        if (this.done) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.relay.getLocalAddress() + ": will not start the Relayer as stop() has been called");
            }
            return;
        }
        try {
            for (RelayConfig.BridgeConfig bridge_config : bridge_configs) {
                Bridge bridge = new Bridge(bridge_config.createChannel(), bridge_config.getClusterName(), bridge_name, new AddressGenerator(){

                    @Override
                    public Address generateAddress() {
                        UUID uuid = UUID.randomUUID();
                        return new SiteUUID(uuid, null, my_site_id);
                    }
                });
                this.bridges.add(bridge);
            }
            for (Bridge bridge : this.bridges) {
                bridge.start();
            }
        }
        catch (Throwable t) {
            this.stop();
            throw t;
        }
        finally {
            if (this.done) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.relay.getLocalAddress() + ": stop() was called while starting the relayer; stopping the relayer now");
                }
                this.stop();
            }
        }
    }

    public void stop() {
        this.done = true;
        for (Bridge bridge : this.bridges) {
            bridge.stop();
        }
        this.bridges.clear();
    }

    public synchronized String printRoutes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.routes.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null || list.isEmpty()) continue;
            sb.append((String)entry.getKey() + " --> ").append(Util.print(list)).append("\n");
        }
        return sb.toString();
    }

    protected synchronized Route getRoute(String site) {
        List list = (List)this.routes.get(site);
        return list == null ? null : (Route)Util.pickRandomElement(list);
    }

    protected List<String> getSiteNames() {
        return new ArrayList<String>(this.routes.keySet());
    }

    protected synchronized List<Route> getRoutes(String ... excluded_sites) {
        ArrayList<Route> retval = new ArrayList<Route>(this.routes.size());
        block0: for (List list : this.routes.values()) {
            for (Route route : list) {
                if (route == null || Relayer.isExcluded(route, excluded_sites)) continue;
                retval.add(route);
                continue block0;
            }
        }
        return retval;
    }

    protected View getBridgeView(String cluster_name) {
        if (cluster_name == null || this.bridges == null) {
            return null;
        }
        for (Bridge bridge : this.bridges) {
            if (bridge.cluster_name == null || !bridge.cluster_name.equals(cluster_name)) continue;
            return bridge.view;
        }
        return null;
    }

    protected static boolean isExcluded(Route route, String ... excluded_sites) {
        if (excluded_sites == null) {
            return false;
        }
        String site = ((SiteUUID)route.site_master).getSite();
        for (String excluded_site : excluded_sites) {
            if (!site.equals(excluded_site)) continue;
            return true;
        }
        return false;
    }

    protected class Bridge
    extends ReceiverAdapter {
        protected JChannel channel;
        protected final String cluster_name;
        protected View view;

        protected Bridge(JChannel ch, String cluster_name, String channel_name, AddressGenerator addr_generator) throws Exception {
            this.channel = ch;
            this.channel.setName(channel_name);
            this.channel.setReceiver(this);
            this.channel.addAddressGenerator(addr_generator);
            this.cluster_name = cluster_name;
        }

        protected void start() throws Exception {
            this.channel.connect(this.cluster_name);
            Relayer.this.log.info("%s: joined bridge cluster '%s'", this.channel.getAddress(), this.cluster_name);
        }

        protected void stop() {
            Relayer.this.log.info("%s: leaving bridge cluster '%s'", this.channel.getAddress(), this.channel.getClusterName());
            Util.close((Closeable)this.channel);
        }

        @Override
        public void receive(Message msg) {
            RELAY2.Relay2Header hdr = (RELAY2.Relay2Header)msg.getHeader(Relayer.this.relay.getId());
            if (hdr == null) {
                Relayer.this.log.warn("received a message without a relay header; discarding it");
                return;
            }
            Relayer.this.relay.handleRelayMessage(hdr, msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            HashSet<String> up2;
            this.view = new_view;
            if (Relayer.this.log.isTraceEnabled()) {
                Relayer.this.log.trace("[Relayer " + this.channel.getAddress() + "] view: " + new_view);
            }
            RouteStatusListener listener = Relayer.this.relay.getRouteStatusListener();
            Map<String, List<Address>> tmp = this.extract(new_view);
            HashSet down2 = listener != null ? new HashSet(Relayer.this.routes.keySet()) : null;
            HashSet<String> hashSet = up2 = listener != null ? new HashSet<String>() : null;
            if (listener != null) {
                down2.removeAll(tmp.keySet());
            }
            Relayer.this.routes.keySet().retainAll(tmp.keySet());
            for (Map.Entry<String, List<Address>> entry : tmp.entrySet()) {
                String key = entry.getKey();
                List<Address> val = entry.getValue();
                if (!Relayer.this.routes.containsKey(key)) {
                    Relayer.this.routes.put(key, new ArrayList());
                    if (up2 != null) {
                        up2.add(key);
                    }
                }
                List list = (List)Relayer.this.routes.get(key);
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Route route = (Route)it.next();
                    if (val.contains(route.siteMaster())) continue;
                    it.remove();
                }
                for (Address addr : val) {
                    if (this.contains(list, addr)) continue;
                    list.add(new Route(addr, this.channel));
                }
                if (!list.isEmpty()) continue;
                Relayer.this.routes.remove(key);
                if (listener == null) continue;
                down2.add(key);
                up2.remove(key);
            }
            if (listener != null) {
                if (!down2.isEmpty()) {
                    listener.sitesDown(down2.toArray(new String[down2.size()]));
                }
                if (!up2.isEmpty()) {
                    listener.sitesUp(up2.toArray(new String[up2.size()]));
                }
            }
        }

        protected boolean contains(List<Route> routes, Address addr) {
            for (Route route : routes) {
                if (!route.siteMaster().equals(addr)) continue;
                return true;
            }
            return false;
        }

        protected Map<String, List<Address>> extract(View view) {
            HashMap<String, List<Address>> map = new HashMap<String, List<Address>>(view.size());
            for (Address mbr : view) {
                SiteAddress member = (SiteAddress)mbr;
                String key = member.getSite();
                ArrayList<SiteAddress> list = (ArrayList<SiteAddress>)map.get(key);
                if (list == null) {
                    list = new ArrayList<SiteAddress>();
                    map.put(key, list);
                }
                if (list.contains(member)) continue;
                list.add(member);
            }
            return map;
        }
    }

    public class Route
    implements Comparable<Route> {
        protected final Address site_master;
        protected final JChannel bridge;

        public Route(Address site_master, JChannel bridge) {
            this.site_master = site_master;
            this.bridge = bridge;
        }

        public JChannel bridge() {
            return this.bridge;
        }

        public Address siteMaster() {
            return this.site_master;
        }

        public void send(Address final_destination, Address original_sender, Message msg) {
            if (Relayer.this.log.isTraceEnabled()) {
                Relayer.this.log.trace("routing message to " + final_destination + " via " + this.site_master);
            }
            long start = Relayer.this.stats ? System.nanoTime() : 0L;
            try {
                Message copy = this.createMessage(this.site_master, final_destination, original_sender, msg);
                this.bridge.send(copy);
                if (Relayer.this.stats) {
                    Relayer.this.relay.addToRelayedTime(System.nanoTime() - start);
                    Relayer.this.relay.incrementRelayed();
                }
            }
            catch (Exception e) {
                Relayer.this.log.error("failure relaying message", e);
            }
        }

        @Override
        public int compareTo(Route o) {
            return this.site_master.compareTo(o.siteMaster());
        }

        public boolean equals(Object obj) {
            return this.compareTo((Route)obj) == 0;
        }

        public int hashCode() {
            return this.site_master.hashCode();
        }

        public String toString() {
            return this.site_master != null ? this.site_master.toString() : "";
        }

        protected Message createMessage(Address target, Address final_destination, Address original_sender, Message msg) {
            Message copy = Relayer.this.relay.copy(msg).dest(target).src(null);
            RELAY2.Relay2Header hdr = new RELAY2.Relay2Header(1, final_destination, original_sender);
            copy.putHeader(Relayer.this.relay.getId(), hdr);
            return copy;
        }
    }
}

