/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.core.api.DownloadService;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.WorkDir;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class DownloadResource
implements DownloadService {
    private final Cache<String, Download> downloadCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Logger logger = LoggerFactory.getLogger(DownloadResource.class);

    public Response download(@PathParam(value="downloadkey") String downloadKey) {
        final Download download = (Download)this.downloadCache.getIfPresent((Object)downloadKey);
        if (download == null) {
            throw new NotFoundException("The download with key [%s] was not found.", new Object[]{downloadKey});
        }
        this.downloadCache.invalidate((Object)downloadKey);
        logger.info("Going to stream download of [{}]", (Object)download.file);
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(download.file);
                    ByteStreams.copy((InputStream)is, (OutputStream)output);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(is);
                    download.workDir.delete();
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)is);
                download.workDir.delete();
            }
        };
        return Response.ok((Object)output, (String)download.contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", download.file.getName())).header("Content-Length", (Object)String.valueOf(download.file.length())).build();
    }

    public String register(File file, WorkDir workDir, String contentType) {
        Download download = new Download(file, workDir, contentType);
        logger.info("Registering download [{}] with key [{}]", (Object)download.file.getPath(), (Object)download.key);
        this.downloadCache.put((Object)download.key, (Object)download);
        return download.key;
    }

    private static class Download {
        private final String key = UUID.randomUUID().toString();
        private final File file;
        private final WorkDir workDir;
        private final String contentType;

        Download(File file, WorkDir workDir, String contentType) {
            this.file = file;
            this.workDir = workDir;
            this.contentType = contentType;
        }
    }
}

