/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClasspathBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PluginClasspathBuilder.class);

    private static Collection<URL> toURL(File pluginDir) throws IOException {
        if (pluginDir.isFile()) {
            return Arrays.asList(pluginDir.toURI().toURL());
        }
        UrlCollector collector = new UrlCollector();
        Files.walkFileTree(pluginDir.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, collector);
        return collector.getUrls();
    }

    public static URLClassLoader build(File ... pluginFilesAndDirectories) {
        try {
            ArrayList<URL> classpath = new ArrayList<URL>();
            for (File f : pluginFilesAndDirectories) {
                classpath.addAll(PluginClasspathBuilder.toURL(f));
            }
            LOG.info("Plugin classpath: {}", classpath);
            URLClassLoader classLoader = new URLClassLoader(classpath.toArray(new URL[classpath.size()]));
            return classLoader;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UrlCollector
    implements FileVisitor<Path> {
        private List<URL> urls = new ArrayList<URL>();

        private UrlCollector() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.urls.add(dir.toUri().toURL());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            LOG.debug("Scanned {} succesfully", (Object)file);
            this.urls.add(file.toUri().toURL());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            LOG.error("Error scanning " + file.toString(), (Throwable)exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null) {
                LOG.debug("Scanned {} successfully", (Object)dir);
            } else {
                LOG.error("Error scanning " + dir.toString(), (Throwable)exc);
            }
            return FileVisitResult.CONTINUE;
        }

        public List<URL> getUrls() {
            return this.urls;
        }
    }
}

