/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api;

import com.xebialabs.xltest.XLTest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowAccessWhenDoneBootingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AllowAccessWhenDoneBootingFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestUrlAsString = AllowAccessWhenDoneBootingFilter.getFullURL(httpServletRequest);
        if (XLTest.isRunning()) {
            if (requestUrlAsString.contains("booting.html") || requestUrlAsString.contains("upgrading.html")) {
                httpServletResponse.sendRedirect("/");
                return;
            }
            chain.doFilter(request, response);
        } else {
            LOG.debug("XL TestView is not in RUNNING state but is {} - request url: {} ", (Object)XLTest.state, (Object)requestUrlAsString);
            if (requestUrlAsString.contains("booting.html") || requestUrlAsString.contains("upgrading.html") || requestUrlAsString.contains(".css")) {
                chain.doFilter(request, response);
            } else {
                if (XLTest.isUpgrading()) {
                    httpServletResponse.sendRedirect("/upgrading.html");
                } else {
                    httpServletResponse.sendRedirect("/booting.html");
                }
                return;
            }
        }
    }

    public static String getFullURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    public void destroy() {
    }
}

