/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.configuration;

import com.typesafe.config.Config;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.api.MetadataServiceImpl;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseInstallService;
import com.xebialabs.license.service.LicenseInstallServiceImpl;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.RegistrationLicenseService;
import com.xebialabs.xlplatform.jcr.ModeShapeRepositoryFactoryBean;
import com.xebialabs.xlplatform.jcr.ModeshapeConfiguration;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlt.plugin.api.repository.QualificationsRepository;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.configuration.SpringContextHolder;
import com.xebialabs.xltest.repository.ValidatingRepository;
import com.xebialabs.xltest.service.ReportService;
import com.xebialabs.xltest.upgrade.jcr.XlTestViewUpgrader;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.SecretKey;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.xebialabs.deployit.service.validation", "com.xebialabs.xlplatform.upgrade", "com.xebialabs.xltest.api", "com.xebialabs.license", "com.xebialabs.xltest.serialize", "com.xebialabs.xltest.service", "com.xebialabs.xltest.repository"})
public class CommonContextConfig {
    @Bean(name={"xlt.license.file"})
    @Autowired
    public String licenseFile(Config config) {
        return config.getString("xlt.license.file");
    }

    @Bean(name={"xlt.data"})
    @Autowired
    public String dataDir(Config config) {
        return config.getString("xlt.data");
    }

    @Bean(name={"xlt.elasticsearch.http"})
    @Autowired
    public boolean elasticSearchHttpServer(Config config) {
        return config.getBoolean("xlt.elasticsearch.http");
    }

    @Bean(name={"xlt.elasticsearch.port-range"})
    @Autowired
    public String elasticSearchPort(Config config) {
        return config.getString("xlt.elasticsearch.port-range");
    }

    @Bean(name={"xlt.elasticsearch.snapshot-location"})
    @Autowired
    public String elasticSearchSnapshotLocations(Config config) {
        return config.getString("xlt.elasticsearch.snapshot-location");
    }

    @Bean(name={"xlt.authentication.method"})
    @Autowired
    public String authenticationMethod(Config config) {
        return config.getString("xlt.authentication.method");
    }

    @Bean(name={"xlt.truststore.location"})
    @Autowired
    public String keystoreLocation(Config config) {
        return config.getString("xlt.truststore.location");
    }

    @Bean(name={"xlt.upgrader.elasticsearch-batch-size"})
    public int upgraderElasticSearchBatchSize(Config config) {
        return config.getInt("xlt.upgrader.elasticsearch-batch-size");
    }

    @Bean
    public MetadataService metadataService() {
        return new MetadataServiceImpl();
    }

    @Bean
    public Repository repository(RepositoryService repositoryService, Validator validator) {
        return new RepositoryAdapter(repositoryService, validator, null);
    }

    @Bean
    public RepositoryServiceHolder repositoryServiceHolder(RepositoryService repositoryService) {
        return new RepositoryServiceHolder(repositoryService);
    }

    @Bean
    public RepositoryMetadataService repositoryMetadataService(JcrTemplate jcrTemplate) {
        return new JcrRepositoryMetadataService(jcrTemplate);
    }

    @Bean
    @Autowired
    public LicenseService licenseService(@Qualifier(value="xlt.license.file") String licenseFile, RepositoryMetadataService repositoryMetadataService) throws IOException {
        return new RegistrationLicenseService(licenseFile, "XL TestView", repositoryMetadataService);
    }

    @Bean
    @Autowired
    public LicenseInstallService licenseInstallService(LicenseService licenseService, @Qualifier(value="xlt.license.file") String licenseFile) {
        return new LicenseInstallServiceImpl(licenseFile, licenseService);
    }

    @Bean
    public ServerConfiguration serverConfiguration() {
        ServerConfiguration serverCfg = new ServerConfiguration();
        serverCfg.setDefaults();
        return serverCfg;
    }

    @Bean
    @Autowired
    public RepositoryService repositoryService(JcrTemplate jcrTemplate, Validator validator, LicenseService licenseService) throws IOException, RepositoryException {
        SecretKey secretKey = DeployitKeys.getPasswordEncryptionKey((String)"keyStorePassword");
        PasswordEncrypter.init((SecretKey)secretKey);
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        JcrRepositoryService jcrRepositoryService = new JcrRepositoryService(jcrTemplate, passwordEncrypter, licenseService);
        licenseService.initialize((RepositoryService)jcrRepositoryService);
        return new ValidatingRepository((RepositoryService)jcrRepositoryService, validator);
    }

    @Bean
    @Autowired
    public JcrTemplate jcrTemplate(javax.jcr.Repository jcrRepository, XlRepositoryConfig repositoryConfig) {
        return new JcrTemplate(jcrRepository, (Credentials)repositoryConfig.credentials().get());
    }

    @Bean
    @Autowired
    TransactionManagerLookup transactionManagerLookup() {
        return new DummyTransactionManagerLookup();
    }

    @Bean
    @Autowired
    public ModeshapeConfiguration modeshapeConfiguration(TransactionManagerLookup transactionManagerLookup, Config config) throws IOException {
        System.setProperty("xlt.data", new File(config.getString("xlt.data")).getCanonicalPath());
        return new ModeshapeConfiguration("xl-tv", transactionManagerLookup, config.getConfig("xlt.repository"));
    }

    @Bean
    @Autowired
    public ModeShapeRepositoryFactoryBean getModeShapeFactory(ModeshapeConfiguration modeshapeConfiguration, XlRepositoryConfig repositoryConfig) {
        return new ModeShapeRepositoryFactoryBean(modeshapeConfiguration, repositoryConfig);
    }

    @Bean
    public ReportService reportService(TestRunsRepository testRunsRepository, AutowireCapableBeanFactory beanFactory, QualificationsRepository qualificationsRepository) {
        return new ReportService(testRunsRepository, beanFactory, qualificationsRepository);
    }

    @Bean
    public ExecutorService executorService() {
        return Executors.newCachedThreadPool();
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    public Upgrader upgrader(JcrTemplate jcrTemplate, RepositoryVersionService repositoryVersionService) {
        return new XlTestViewUpgrader(jcrTemplate, repositoryVersionService);
    }
}

