/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain.freemarker;

import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

@Metadata(description="Freemarker report base type", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true, versioned=false)
public class Report
extends com.xebialabs.xltest.domain.Report {
    private static Logger LOG = LoggerFactory.getLogger(Report.class);
    @Property(required=false)
    private Map<String, String> contextProperties = new HashMap<String, String>();
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    @Override
    public String compute(TestRun testRun, TestRunsRepository testRunsRepository) {
        String format;
        try {
            format = this.readTemplateFile(this.getScriptLocation());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not perform freemarker report transformation.", e);
        }
        HashMap<String, Object> templateProperties = new HashMap<String, Object>(this.getAttributes());
        templateProperties.put("test_run", testRun);
        templateProperties.put("test_runs", testRunsRepository);
        templateProperties.put("this", (Object)this);
        this.injectContextProperties(templateProperties);
        return this.format(templateProperties, format);
    }

    private void injectContextProperties(Map<String, Object> templateProperties) {
        for (Map.Entry<String, String> entry : this.contextProperties.entrySet()) {
            Object instance = null;
            try {
                instance = Class.forName(entry.getValue()).newInstance();
            }
            catch (Exception e) {
                LOG.error("Can't inject {} of type {} into the freemarker context", new Object[]{entry.getKey(), entry.getValue(), e});
            }
            this.beanFactory.autowireBean(instance);
            templateProperties.put(entry.getKey(), instance);
        }
    }

    private String readTemplateFile(String fileName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LOG.debug("reading FTL template '{}' with classloader {}", (Object)fileName, (Object)classLoader);
        URL url = classLoader.getResource(fileName);
        return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
    }

    private String format(Map<String, Object> properties, String format) {
        try {
            Configuration cfg = new Configuration();
            cfg.clearTemplateCache();
            Template t = new Template(this.getScriptLocation(), (Reader)new StringReader(format), cfg);
            StringWriter sw = new StringWriter();
            t.process(properties, (Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (TemplateException e) {
            return e.getMessage();
        }
    }

    public String nextDate(Date date) {
        Date nextDate = new Date(date.getTime() + 86400000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(nextDate);
    }

    public String previousDate(Date date) {
        Date previousDate = new Date(date.getTime() - 86400000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(previousDate);
    }

    public String thisDay(Long date) {
        SimpleDateFormat format = new SimpleDateFormat("dd");
        return format.format(new Date(date));
    }

    public String getAttributeAsString(String key) {
        if (this.getAttributes() != null) {
            return this.getAttributes().get(key).toString();
        }
        return "";
    }
}

