/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HostRepository {
    private final RepositoryService repository;

    @Autowired
    public HostRepository(RepositoryService repositoryService) {
        this.repository = repositoryService;
    }

    public Host findHost(String addressToLookFor, int portToLookFor, String hostType) {
        SearchParameters criteria = new SearchParameters().setType(Type.valueOf((String)hostType)).setDepth(1);
        List hosts = this.repository.listEntities(criteria);
        for (Host host : hosts) {
            String address = null;
            int port = 0;
            try {
                address = (String)host.getProperty("address");
                if (host.hasProperty("port")) {
                    port = (Integer)host.getProperty("port");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!addressToLookFor.equals(address) || portToLookFor != port) continue;
            host.setId(host.getId());
            return host;
        }
        return null;
    }

    public static Host create(String type, String address, String username, String password) {
        Host host;
        if ("overthere.LocalHost".equalsIgnoreCase(type)) {
            host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.LocalHost")).newInstance("");
            host.setOs(OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        } else if ("overthere.SshHost".equalsIgnoreCase(type)) {
            host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.SshHost")).newInstance("");
            host.setProperty("address", (Object)address);
            host.setProperty("username", (Object)username);
            host.setProperty("password", (Object)password);
            host.setOs(OperatingSystemFamily.UNIX);
        } else if ("overthere.CifsHost".equalsIgnoreCase(type)) {
            host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.CifsHost")).newInstance("");
            host.setProperty("address", (Object)address);
            host.setProperty("username", (Object)username);
            host.setProperty("password", (Object)password);
            host.setOs(OperatingSystemFamily.WINDOWS);
        } else {
            throw new AssertionError((Object)String.format("Protocol %s is not supported.", type));
        }
        return host;
    }
}

