/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkDir
implements Serializable {
    private final LocalFile workDir;
    private static final Logger logger = LoggerFactory.getLogger(WorkDir.class);

    public WorkDir(LocalFile workDir) {
        this.workDir = workDir;
    }

    public LocalFile newFile(String filename) {
        Preconditions.checkState((boolean)this.workDir.exists(), (String)"Cannot create a new file when workDir [%s] does not exist.", (Object[])new Object[]{this.workDir});
        return (LocalFile)OverthereUtils.getUniqueFolder((OverthereFile)this.workDir, (String)"artifact").getFile(filename);
    }

    public String getPath() {
        return this.workDir.getPath();
    }

    public void delete() {
        logger.debug("Deleting workDir {}", (Object)this);
        if (this.workDir.exists()) {
            try {
                this.workDir.deleteRecursively();
            }
            catch (Exception e) {
                logger.warn("Could not delete [{}]; you can do this manually.", (Object)this.workDir.getPath());
                logger.debug(String.format("The reason is: %s", e.getMessage()), (Throwable)e);
            }
        } else {
            logger.debug("Workdirectory {} already deleted.", (Object)this);
        }
    }

    public String toString() {
        return "WorkDir[" + this.getPath() + "]";
    }
}

