/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.query.QueryEngine;
import org.modeshape.jcr.query.optimize.Optimizer;
import org.modeshape.jcr.query.optimize.RuleBasedOptimizer;
import org.modeshape.jcr.query.plan.CanonicalPlanner;
import org.modeshape.jcr.query.plan.Planner;
import org.modeshape.jcr.spi.index.IndexManager;

public abstract class QueryEngineBuilder {
    private RepositoryConfiguration config;
    private IndexManager indexManager;
    private ExecutionContext context;
    private Planner planner;
    private Optimizer optimizer;

    public QueryEngineBuilder using(RepositoryConfiguration configuration, IndexManager indexManager, ExecutionContext context) {
        this.config = configuration;
        this.context = context;
        this.indexManager = indexManager;
        return this;
    }

    public QueryEngineBuilder with(Planner planner) {
        this.planner = planner;
        return this;
    }

    public QueryEngineBuilder with(Optimizer optimizer) {
        this.optimizer = optimizer;
        return this;
    }

    public abstract QueryEngine build();

    protected final RepositoryConfiguration config() {
        return this.config;
    }

    protected final ExecutionContext context() {
        return this.context;
    }

    protected final IndexManager indexManager() {
        return this.indexManager;
    }

    protected String repositoryName() {
        return this.config().getName();
    }

    protected final Planner planner() {
        return this.planner != null ? this.planner : this.defaultPlanner();
    }

    protected final Optimizer optimizer() {
        return this.optimizer != null ? this.optimizer : this.defaultOptimizer();
    }

    protected Planner defaultPlanner() {
        return new CanonicalPlanner();
    }

    protected Optimizer defaultOptimizer() {
        return new RuleBasedOptimizer();
    }
}

