/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.Comparator;
import java.util.LinkedList;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.engine.IndexPlan;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

public class OrderIndexesByCost
implements OptimizerRule {
    public static final OrderIndexesByCost INSTANCE = new OrderIndexesByCost();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode source : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
            source.orderChildren(PlanNode.Type.INDEX, new Comparator<PlanNode>(){

                @Override
                public int compare(PlanNode o1, PlanNode o2) {
                    IndexPlan index1 = o1.getProperty(PlanNode.Property.INDEX_SPECIFICATION, IndexPlan.class);
                    IndexPlan index2 = o2.getProperty(PlanNode.Property.INDEX_SPECIFICATION, IndexPlan.class);
                    assert (index1 != null);
                    assert (index2 != null);
                    return index1.compareTo(index2);
                }
            });
        }
        return plan;
    }
}

