/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.spi.index.IndexCostCalculator;

public abstract class IndexPlanner {
    public abstract void applyIndexes(QueryContext var1, IndexCostCalculator var2);

    public static IndexPlanner both(final IndexPlanner planner1, final IndexPlanner planner2) {
        if (planner1 == null) {
            return planner2;
        }
        if (planner2 == null) {
            return planner1;
        }
        return new IndexPlanner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void applyIndexes(QueryContext context, IndexCostCalculator calculator) {
                RuntimeException error = null;
                try {
                    planner1.applyIndexes(context, calculator);
                    return;
                }
                catch (RuntimeException e) {
                    error = e;
                }
                finally {
                    try {
                        planner2.applyIndexes(context, calculator);
                    }
                    catch (RuntimeException e) {
                        if (error == null) {
                            error = e;
                        }
                    }
                    finally {
                        if (error == null) return;
                        throw error;
                    }
                }
            }
        };
    }
}

