/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceException;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;
import org.modeshape.jcr.value.basic.BasicName;

@Immutable
public class NameValueFactory
extends AbstractValueFactory<Name>
implements NameFactory {
    private static final Name BLANK_NAME = new BasicName("", "");
    private static final Name ANY_NAME = new BasicName("", "*");
    private final NamespaceRegistry.Holder namespaceRegistryHolder;

    public NameValueFactory(NamespaceRegistry.Holder namespaceRegistryHolder, TextDecoder decoder, ValueFactories factories) {
        super(PropertyType.NAME, decoder, factories);
        CheckArg.isNotNull((Object)namespaceRegistryHolder, (String)"namespaceRegistryHolder");
        this.namespaceRegistryHolder = namespaceRegistryHolder;
    }

    @Override
    public NameFactory with(ValueFactories valueFactories) {
        return this.valueFactories == valueFactories ? this : new NameValueFactory(this.namespaceRegistryHolder, super.getDecoder(), valueFactories);
    }

    @Override
    public NameFactory with(NamespaceRegistry.Holder namespaceRegistryHolder) {
        return this.namespaceRegistryHolder == namespaceRegistryHolder ? this : new NameValueFactory(namespaceRegistryHolder, super.getDecoder(), this.valueFactories);
    }

    @Override
    public Name create(String value) {
        return this.create(value, this.getDecoder());
    }

    @Override
    public Name create(String value, TextDecoder decoder) {
        block14: {
            if (value == null) {
                return null;
            }
            if (decoder == null) {
                decoder = this.getDecoder();
            }
            try {
                if (value.length() == 0) {
                    return BLANK_NAME;
                }
                char firstChar = value.charAt(0);
                if (value.length() == 1 && firstChar == '*') {
                    return ANY_NAME;
                }
                if (firstChar == ':') {
                    if (value.length() == 1) {
                        return BLANK_NAME;
                    }
                    throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Name.class.getSimpleName(), value}));
                }
                if (firstChar == '{') {
                    int closingBraceIndex = value.indexOf(125, 1);
                    if (closingBraceIndex == 1) {
                        if (value.length() == 2) {
                            return BLANK_NAME;
                        }
                        String namespaceUri = this.namespaceRegistryHolder.getNamespaceRegistry().getNamespaceForPrefix("");
                        String localName = decoder.decode(value.substring(2));
                        return new BasicName(namespaceUri, localName);
                    }
                    if (closingBraceIndex > 1) {
                        String namespaceUri = value.substring(1, closingBraceIndex);
                        int nextIndexAfterClosingBrace = closingBraceIndex + 1;
                        String localName = nextIndexAfterClosingBrace < value.length() ? value.substring(nextIndexAfterClosingBrace) : "";
                        return this.create(namespaceUri, localName, decoder);
                    }
                    break block14;
                }
                int colonIndex = value.indexOf(58);
                if (colonIndex < 1) {
                    String namespaceUri = this.namespaceRegistryHolder.getNamespaceRegistry().getNamespaceForPrefix("");
                    String localName = decoder.decode(value);
                    return new BasicName(namespaceUri, localName);
                }
                String prefix = value.substring(0, colonIndex);
                prefix = decoder.decode(prefix);
                String namespaceUri = this.namespaceRegistryHolder.getNamespaceRegistry().getNamespaceForPrefix(prefix);
                if (namespaceUri == null) {
                    throw new NamespaceException(GraphI18n.noNamespaceRegisteredForPrefix.text(new Object[]{prefix}));
                }
                int nextIndexAfterColon = colonIndex + 1;
                String localName = nextIndexAfterColon < value.length() ? value.substring(nextIndexAfterColon) : "";
                localName = decoder.decode(localName);
                return new BasicName(namespaceUri, localName);
            }
            catch (NamespaceException err) {
                throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Name.class.getSimpleName(), value}), err);
            }
        }
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Name create(String namespaceUri, String localName) {
        return this.create(namespaceUri, localName, this.getDecoder());
    }

    @Override
    public Name create(String namespaceUri, String localName, TextDecoder decoder) {
        CheckArg.isNotEmpty((String)localName, (String)"localName");
        if (decoder == null) {
            decoder = this.getDecoder();
        }
        namespaceUri = namespaceUri != null ? decoder.decode(namespaceUri.trim()) : null;
        localName = decoder.decode(localName.trim());
        return new BasicName(namespaceUri, localName);
    }

    @Override
    public Name create(int value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public Name create(long value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public Name create(boolean value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public Name create(float value) {
        throw new ValueFormatException(Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public Name create(double value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public Name create(BigDecimal value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Calendar value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Date value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public Name create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Name value) {
        return value;
    }

    @Override
    public Name create(Path value) {
        Path.Segment segment;
        if (value == null) {
            return null;
        }
        if (!value.isAbsolute() && value.size() == 1 && !(segment = value.getLastSegment()).hasIndex()) {
            return segment.getName();
        }
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{Path.class.getSimpleName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Path.Segment segment) {
        if (segment == null) {
            return null;
        }
        if (!segment.hasIndex()) {
            return segment.getName();
        }
        throw new ValueFormatException(segment, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{Path.Segment.class.getSimpleName(), Name.class.getSimpleName(), segment}));
    }

    @Override
    public Name create(Reference value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public Name create(URI value) {
        if (value == null) {
            return null;
        }
        String asciiString = value.toASCIIString();
        if (asciiString.startsWith("./") && asciiString.length() > 2) {
            asciiString = asciiString.substring(2);
        }
        if (asciiString.indexOf(47) == -1) {
            return this.create(asciiString);
        }
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{URI.class.getSimpleName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Name create(UUID value) throws IoException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public Name create(NodeKey value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
    }

    @Override
    public Name create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Name create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Name create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistryHolder.getNamespaceRegistry();
    }

    public Name[] createEmptyArray(int length) {
        return new Name[length];
    }
}

