/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardFlushRequest
extends BroadcastShardOperationRequest {
    private boolean force;
    private boolean waitIfOngoing;

    ShardFlushRequest() {
    }

    ShardFlushRequest(ShardId shardId, FlushRequest request) {
        super(shardId, request);
        this.force = request.force();
        this.waitIfOngoing = request.waitIfOngoing();
    }

    public boolean force() {
        return this.force;
    }

    public boolean waitIfOngoing() {
        return this.waitIfOngoing;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        in.readBoolean();
        this.force = in.readBoolean();
        this.waitIfOngoing = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(false);
        out.writeBoolean(this.force);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeBoolean(this.waitIfOngoing);
        }
    }
}

