/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UpgradeSettingsRequest
extends AcknowledgedRequest<UpgradeSettingsRequest> {
    private Map<String, String> versions;

    UpgradeSettingsRequest() {
    }

    public UpgradeSettingsRequest(Map<String, String> versions) {
        this.versions = versions;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.versions.isEmpty()) {
            validationException = ValidateActions.addValidationError("no indices to update", validationException);
        }
        return validationException;
    }

    Map<String, String> versions() {
        return this.versions;
    }

    public UpgradeSettingsRequest versions(Map<String, String> versions) {
        this.versions = versions;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.versions = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            String version = in.readString();
            this.versions.put(index, version);
        }
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.versions.size());
        for (Map.Entry<String, String> entry : this.versions.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        this.writeTimeout(out);
    }
}

