/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;

public abstract class AckedClusterStateUpdateTask<Response>
extends TimeoutClusterStateUpdateTask {
    private final ActionListener<Response> listener;
    private final AckedRequest request;

    protected AckedClusterStateUpdateTask(AckedRequest request, ActionListener<Response> listener) {
        this.listener = listener;
        this.request = request;
    }

    public boolean mustAck(DiscoveryNode discoveryNode) {
        return true;
    }

    public void onAllNodesAcked(@Nullable Throwable t) {
        this.listener.onResponse(this.newResponse(true));
    }

    protected abstract Response newResponse(boolean var1);

    public void onAckTimeout() {
        this.listener.onResponse(this.newResponse(false));
    }

    @Override
    public void onFailure(String source, Throwable t) {
        this.listener.onFailure(t);
    }

    @Override
    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
    }

    public TimeValue ackTimeout() {
        return this.request.ackTimeout();
    }

    @Override
    public TimeValue timeout() {
        return this.request.masterNodeTimeout();
    }
}

