/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.socks;

import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.handler.codec.replay.ReplayingDecoder;
import org.elasticsearch.common.netty.handler.codec.socks.SocksCmdResponse;
import org.elasticsearch.common.netty.handler.codec.socks.SocksCommonUtils;
import org.elasticsearch.common.netty.handler.codec.socks.SocksMessage;
import org.elasticsearch.common.netty.handler.codec.socks.SocksResponse;
import org.elasticsearch.common.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksCmdResponseDecoder
extends ReplayingDecoder<State> {
    private SocksMessage.ProtocolVersion version;
    private int fieldLength;
    private SocksMessage.CmdStatus cmdStatus;
    private SocksMessage.AddressType addressType;
    private byte reserved;
    private String host;
    private int port;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    public SocksCmdResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        block0 : switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdStatus = SocksMessage.CmdStatus.fromByte(buffer.readByte());
                this.reserved = buffer.readByte();
                this.addressType = SocksMessage.AddressType.fromByte(buffer.readByte());
                this.checkpoint(State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        this.host = SocksCommonUtils.intToIp(buffer.readInt());
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                    case DOMAIN: {
                        this.fieldLength = buffer.readByte();
                        this.host = buffer.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                    case IPv6: {
                        this.host = SocksCommonUtils.ipv6toStr(buffer.readBytes(16).array());
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                }
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_CMD_HEADER,
        READ_CMD_ADDRESS;

    }
}

