/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.cbor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.jackson.dataformat.cbor.CBORParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.cbor.CborXContent;
import org.elasticsearch.common.xcontent.json.BaseJsonGenerator;
import org.elasticsearch.common.xcontent.json.JsonXContentGenerator;

public class CborXContentGenerator
extends JsonXContentGenerator {
    public CborXContentGenerator(BaseJsonGenerator generator) {
        super(generator);
    }

    @Override
    public XContentType contentType() {
        return XContentType.CBOR;
    }

    @Override
    public void usePrintLineFeedAtEnd() {
    }

    @Override
    public void writeRawField(String fieldName, InputStream content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (CBORParser parser = CborXContent.cborFactory.createParser(content);){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }

    @Override
    public void writeRawField(String fieldName, byte[] content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (CBORParser parser = CborXContent.cborFactory.createParser(content);){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectRaw(String fieldName, BytesReference content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (CBORParser parser = content.hasArray() ? CborXContent.cborFactory.createParser(content.array(), content.arrayOffset(), content.length()) : CborXContent.cborFactory.createParser(content.streamInput());){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }

    @Override
    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (CBORParser parser = CborXContent.cborFactory.createParser(content, offset, length);){
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
    }
}

