/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptService;

public class ScriptParameterParser {
    public static final String FILE_SUFFIX = "_file";
    public static final String INDEXED_SUFFIX = "_id";
    private Map<String, ScriptParameterValue> parameterValues = new HashMap<String, ScriptParameterValue>();
    private Set<ParseField> inlineParameters;
    private Set<ParseField> fileParameters;
    private Set<ParseField> indexedParameters;
    private String lang = null;

    public ScriptParameterParser() {
        this(null);
    }

    public ScriptParameterParser(Set<String> parameterNames) {
        if (parameterNames == null || parameterNames.isEmpty()) {
            this.inlineParameters = Collections.singleton(ScriptService.SCRIPT_INLINE);
            this.fileParameters = Collections.singleton(ScriptService.SCRIPT_FILE);
            this.indexedParameters = Collections.singleton(ScriptService.SCRIPT_ID);
        } else {
            this.inlineParameters = new HashSet<ParseField>();
            this.fileParameters = new HashSet<ParseField>();
            this.indexedParameters = new HashSet<ParseField>();
            for (String parameterName : parameterNames) {
                if (ScriptService.SCRIPT_LANG.match(parameterName)) {
                    throw new IllegalArgumentException("lang is reserved and cannot be used as a parameter name");
                }
                this.inlineParameters.add(new ParseField(parameterName, new String[0]));
                this.fileParameters.add(new ParseField(parameterName + FILE_SUFFIX, new String[0]));
                this.indexedParameters.add(new ParseField(parameterName + INDEXED_SUFFIX, new String[0]));
            }
        }
    }

    public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            if (ScriptService.SCRIPT_LANG.match(currentFieldName)) {
                this.lang = parser.text();
                return true;
            }
            for (ParseField parameter : this.inlineParameters) {
                if (!parameter.match(currentFieldName)) continue;
                String coreParameterName = parameter.getPreferredName();
                this.putParameterValue(coreParameterName, parser.textOrNull(), ScriptService.ScriptType.INLINE);
                return true;
            }
            for (ParseField parameter : this.fileParameters) {
                if (!parameter.match(currentFieldName)) continue;
                String coreParameterName = parameter.getPreferredName().replace(FILE_SUFFIX, "");
                this.putParameterValue(coreParameterName, parser.textOrNull(), ScriptService.ScriptType.FILE);
                return true;
            }
            for (ParseField parameter : this.indexedParameters) {
                if (!parameter.match(currentFieldName)) continue;
                String coreParameterName = parameter.getPreferredName().replace(INDEXED_SUFFIX, "");
                this.putParameterValue(coreParameterName, parser.textOrNull(), ScriptService.ScriptType.INDEXED);
                return true;
            }
        }
        return false;
    }

    public void parseConfig(Map<String, Object> config, boolean removeMatchedEntries) {
        Iterator<Map.Entry<String, Object>> itr = config.entrySet().iterator();
        while (itr.hasNext()) {
            String stringValue;
            String coreParameterName;
            Map.Entry<String, Object> entry = itr.next();
            String parameterName = entry.getKey();
            Object parameterValue = entry.getValue();
            if (ScriptService.SCRIPT_LANG.match(parameterName)) {
                if (parameterValue instanceof String || parameterValue == null) {
                    this.lang = (String)parameterValue;
                    if (!removeMatchedEntries) continue;
                    itr.remove();
                    continue;
                }
                throw new ScriptParameterParseException("Value must be of type String: [" + parameterName + "]");
            }
            for (ParseField parameter : this.inlineParameters) {
                if (!parameter.match(parameterName)) continue;
                coreParameterName = parameter.getPreferredName();
                stringValue = null;
                if (!(parameterValue instanceof String)) {
                    throw new ScriptParameterParseException("Value must be of type String: [" + parameterName + "]");
                }
                stringValue = (String)parameterValue;
                this.putParameterValue(coreParameterName, stringValue, ScriptService.ScriptType.INLINE);
                if (!removeMatchedEntries) continue;
                itr.remove();
            }
            for (ParseField parameter : this.fileParameters) {
                if (!parameter.match(parameterName)) continue;
                coreParameterName = parameter.getPreferredName().replace(FILE_SUFFIX, "");
                stringValue = null;
                if (!(parameterValue instanceof String)) {
                    throw new ScriptParameterParseException("Value must be of type String: [" + parameterName + "]");
                }
                stringValue = (String)parameterValue;
                this.putParameterValue(coreParameterName, stringValue, ScriptService.ScriptType.FILE);
                if (!removeMatchedEntries) continue;
                itr.remove();
            }
            for (ParseField parameter : this.indexedParameters) {
                if (!parameter.match(parameterName)) continue;
                coreParameterName = parameter.getPreferredName().replace(INDEXED_SUFFIX, "");
                stringValue = null;
                if (!(parameterValue instanceof String)) {
                    throw new ScriptParameterParseException("Value must be of type String: [" + parameterName + "]");
                }
                stringValue = (String)parameterValue;
                this.putParameterValue(coreParameterName, stringValue, ScriptService.ScriptType.INDEXED);
                if (!removeMatchedEntries) continue;
                itr.remove();
            }
        }
    }

    private void putParameterValue(String coreParameterName, String script, ScriptService.ScriptType scriptType) {
        if (this.parameterValues.get(coreParameterName) != null) {
            throw new ScriptParameterParseException("Only one of [" + coreParameterName + ", " + coreParameterName + FILE_SUFFIX + ", " + coreParameterName + INDEXED_SUFFIX + "] is allowed.");
        }
        this.parameterValues.put(coreParameterName, new ScriptParameterValue(script, scriptType));
    }

    public void parseParams(ToXContent.Params params) {
        String coreParameterName;
        String value;
        this.lang = params.param(ScriptService.SCRIPT_LANG.getPreferredName());
        for (ParseField parameter : this.inlineParameters) {
            value = params.param(parameter.getPreferredName());
            if (value == null) continue;
            coreParameterName = parameter.getPreferredName();
            this.putParameterValue(coreParameterName, value, ScriptService.ScriptType.INLINE);
        }
        for (ParseField parameter : this.fileParameters) {
            value = params.param(parameter.getPreferredName());
            if (value == null) continue;
            coreParameterName = parameter.getPreferredName().replace(FILE_SUFFIX, "");
            this.putParameterValue(coreParameterName, value, ScriptService.ScriptType.FILE);
        }
        for (ParseField parameter : this.indexedParameters) {
            value = params.param(parameter.getPreferredName());
            if (value == null) continue;
            coreParameterName = parameter.getPreferredName().replace(INDEXED_SUFFIX, "");
            this.putParameterValue(coreParameterName, value, ScriptService.ScriptType.INDEXED);
        }
    }

    public ScriptParameterValue getDefaultScriptParameterValue() {
        return this.getScriptParameterValue(ScriptService.SCRIPT_INLINE.getPreferredName());
    }

    public ScriptParameterValue getScriptParameterValue(String parameterName) {
        return this.parameterValues.get(parameterName);
    }

    public String lang() {
        return this.lang;
    }

    public static class ScriptParameterParseException
    extends ElasticsearchException {
        public ScriptParameterParseException(String msg) {
            super(msg);
        }
    }

    public static class ScriptParameterValue {
        private String script;
        private ScriptService.ScriptType scriptType;

        public ScriptParameterValue(String script, ScriptService.ScriptType scriptType) {
            this.script = script;
            this.scriptType = scriptType;
        }

        public String script() {
            return this.script;
        }

        public ScriptService.ScriptType scriptType() {
            return this.scriptType;
        }
    }
}

