/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;

public abstract class InternalSingleBucketAggregation
extends InternalAggregation
implements SingleBucketAggregation {
    private long docCount;
    private InternalAggregations aggregations;

    protected InternalSingleBucketAggregation() {
    }

    protected InternalSingleBucketAggregation(String name, long docCount, InternalAggregations aggregations) {
        super(name);
        this.docCount = docCount;
        this.aggregations = aggregations;
    }

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    protected abstract InternalSingleBucketAggregation newAggregation(String var1, long var2, InternalAggregations var4);

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        long docCount = 0L;
        ArrayList<InternalAggregations> subAggregationsList = new ArrayList<InternalAggregations>(aggregations.size());
        for (InternalAggregation aggregation : aggregations) {
            assert (aggregation.getName().equals(this.getName()));
            docCount += ((InternalSingleBucketAggregation)aggregation).docCount;
            subAggregationsList.add(((InternalSingleBucketAggregation)aggregation).aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(subAggregationsList, reduceContext);
        return this.newAggregation(this.getName(), docCount, aggs);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.docCount = in.readVLong();
        this.aggregations = InternalAggregations.readAggregations(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.docCount);
        this.aggregations.writeTo(out);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        return builder;
    }
}

