/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.filters.Filters;

public class InternalFilters
extends InternalAggregation
implements Filters {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("filters");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalFilters readResult(StreamInput in) throws IOException {
            InternalFilters filters = new InternalFilters();
            filters.readFrom(in);
            return filters;
        }
    };
    private List<Bucket> buckets;
    private Map<String, Bucket> bucketMap;
    private boolean keyed;

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    public InternalFilters() {
    }

    public InternalFilters(String name, List<Bucket> buckets, boolean keyed) {
        super(name);
        this.buckets = buckets;
        this.keyed = keyed;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    public Collection<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public Bucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, Bucket>(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        ArrayList bucketsList = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalFilters internalFilters = (InternalFilters)aggregation;
            if (bucketsList == null) {
                bucketsList = new ArrayList(internalFilters.buckets.size());
                for (Bucket bucket : internalFilters.buckets) {
                    ArrayList<Bucket> sameRangeList = new ArrayList<Bucket>(aggregations.size());
                    sameRangeList.add(bucket);
                    bucketsList.add(sameRangeList);
                }
                continue;
            }
            int i = 0;
            for (Bucket bucket : internalFilters.buckets) {
                ((List)bucketsList.get(i++)).add(bucket);
            }
        }
        InternalFilters reduced = new InternalFilters(this.name, new ArrayList<Bucket>(bucketsList.size()), this.keyed);
        for (List list : bucketsList) {
            reduced.buckets.add(((Bucket)list.get(0)).reduce(list, reduceContext));
        }
        return reduced;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<Bucket> buckets = Lists.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readOptionalString();
            buckets.add(new Bucket(key, in.readVLong(), InternalAggregations.readAggregations(in)));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            out.writeOptionalString(bucket.key);
            out.writeVLong(bucket.docCount);
            bucket.aggregations.writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.BUCKETS);
        } else {
            builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        }
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params, this.keyed);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    public static class Bucket
    implements Filters.Bucket {
        private String key;
        private long docCount;
        InternalAggregations aggregations;

        public Bucket(String key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(this.getKey());
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        Bucket reduce(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
            Bucket reduced = null;
            ArrayList<InternalAggregations> aggregationsList = Lists.newArrayListWithCapacity(buckets.size());
            for (Bucket bucket : buckets) {
                if (reduced == null) {
                    reduced = new Bucket(bucket.key, bucket.docCount, bucket.aggregations);
                } else {
                    reduced.docCount += bucket.docCount;
                }
                aggregationsList.add(bucket.aggregations);
            }
            reduced.aggregations = InternalAggregations.reduce(aggregationsList, context);
            return reduced;
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed) throws IOException {
            if (keyed) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }
    }
}

