/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.internal.producers.SingleDelayedProducer;

public final class OperatorAny<T>
implements Observable.Operator<Boolean, T> {
    private final Func1<? super T, Boolean> predicate;
    private final boolean returnOnEmpty;

    public OperatorAny(Func1<? super T, Boolean> predicate, boolean returnOnEmpty) {
        this.predicate = predicate;
        this.returnOnEmpty = returnOnEmpty;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Boolean> child) {
        final SingleDelayedProducer<? super Boolean> producer = new SingleDelayedProducer<Boolean>(child);
        Subscriber s = new Subscriber<T>(){
            boolean hasElements;
            boolean done;

            @Override
            public void onNext(T t) {
                boolean result;
                this.hasElements = true;
                try {
                    result = (Boolean)OperatorAny.this.predicate.call(t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                    return;
                }
                if (result && !this.done) {
                    this.done = true;
                    producer.setValue(!OperatorAny.this.returnOnEmpty);
                    this.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    if (this.hasElements) {
                        producer.setValue(false);
                    } else {
                        producer.setValue(OperatorAny.this.returnOnEmpty);
                    }
                }
            }
        };
        child.add(s);
        child.setProducer(producer);
        return s;
    }
}

