/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlt.plugin.api.resultparser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportFailedException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UnexpectedFormatException
extends ImportFailedException {
    private final List<String> files;

    public UnexpectedFormatException(String message, Collection<OverthereFile> files) {
        super(message);
        if (files == null || files.isEmpty()) {
            throw new IllegalArgumentException("Expecting a list of files");
        }
        this.files = ImmutableList.builder().addAll((Iterable)files.stream().map(f -> f.getPath()).collect(Collectors.toList())).build();
    }

    public UnexpectedFormatException(String message, Collection<String> files, Optional<String> tempDir) {
        super(message);
        Preconditions.checkNotNull(tempDir, (Object)"Expecting a temp directory value");
        if (files == null || files.isEmpty()) {
            throw new IllegalArgumentException("Expecting a list of files");
        }
        if (tempDir.isPresent()) {
            String escapedTempDir = Pattern.quote(tempDir.get());
            this.files = ImmutableList.builder().addAll((Iterable)files.stream().map(file -> file.replaceFirst(escapedTempDir, "")).collect(Collectors.toList())).build();
        } else {
            this.files = ImmutableList.builder().addAll(files).build();
        }
    }

    public List<String> getFiles() {
        return this.files;
    }
}

