/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.joda.convert.ReflectionStringConverter;

final class MethodsStringConverter<T>
extends ReflectionStringConverter<T> {
    private final Method fromString;

    MethodsStringConverter(Class<T> clazz, Method method, Method method2) {
        super(clazz, method);
        if (method2.getParameterTypes().length != 1) {
            throw new IllegalStateException("FromString method must have one parameter");
        }
        Class<?> clazz2 = method2.getParameterTypes()[0];
        if (clazz2 != String.class && clazz2 != CharSequence.class) {
            throw new IllegalStateException("FromString method must take a String or CharSequence");
        }
        if (!method2.getReturnType().isAssignableFrom(clazz)) {
            throw new IllegalStateException("FromString method must return specified class or a superclass");
        }
        this.fromString = method2;
    }

    @Override
    public T convertFromString(Class<? extends T> clazz, String string) {
        try {
            return clazz.cast(this.fromString.invoke(null, string));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Method is not accessible");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException.getCause());
        }
    }
}

