/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Map;
import java.util.TreeMap;

public class UserAuthenticationData {
    public static final Type USERNAME = new Type("username");
    public static final Type PASSWORD = new Type("password");
    public static final Type DOMAIN = new Type("domain");
    private final Map<Type, char[]> authenticationData = new TreeMap<Type, char[]>();

    public void setData(Type type, char[] data) {
        this.authenticationData.put(type, data);
    }

    public char[] getData(Type type) {
        return this.authenticationData.get(type);
    }

    public void cleanup() {
        for (char[] data : this.authenticationData.values()) {
            if (data == null || data.length < 0) continue;
            for (int i = 0; i < data.length; ++i) {
                data[i] = '\u0000';
            }
        }
        this.authenticationData.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Type
    implements Comparable<Type> {
        private final String type;

        public Type(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type type1 = (Type)o;
            return !(this.type != null ? !this.type.equals(type1.type) : type1.type != null);
        }

        @Override
        public int compareTo(Type o) {
            return this.type.compareTo(o.type);
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }

        public String toString() {
            return this.type;
        }
    }
}

