#!/bin/sh
#
# Shell script to setup the XL TestView Server as a service
#
# NOTE: Keep in sync with upstart script service/unix/xl-testview.conf

absdirname ()
{
  _dir="`dirname \"$1\"`"
  cd "$_dir"
  echo "`pwd`"
}

resolvelink() {
  _dir=`dirname "$1"`
  _dest=`readlink "$1"`
  case "$_dest" in
  /* ) echo "$_dest" ;;
  *  ) echo "$_dir/$_dest" ;;
  esac
}

# Get server home dir
self="$0"
if [ -h "$self" ]; then
  self=`resolvelink "$self"`
fi
BIN_DIR=`absdirname "$self"`
XLT_SERVER_HOME=`dirname "$BIN_DIR"`

xlt_user=xl-testview
xlt_group=xl-testview

if ! id "${xlt_user}" > /dev/null 2>&1; then
  echo "Creating service account ${xlt_user}"
  useradd -d "${XLT_SERVER_HOME}" -M -r ${xlt_user}
else
  echo "Service account ${xlt_user} already exists"
fi

# Set things up so the service user has write permissions only in places
# where it needs it.
echo "Restricting file permissions on ${XLT_SERVER_HOME}"
chown -R root.${xlt_group} "${XLT_SERVER_HOME}"
chmod -R u=rwX,g=rX,o-rwx "${XLT_SERVER_HOME}"
for i in data log conf; do
  d="${XLT_SERVER_HOME}/${i}"
  [ -d "$d" ] || mkdir "$d"
  chown root.${xlt_group} "$d"
  chmod -R u=rwX,g=rwX,o-rwx "$d"
done

echo "Make 'Example pipeline' project test materials usable."
if [ -d "${XLT_SERVER_HOME}/testmaterials" ]; then
  chown -R ${xlt_user}.${xlt_group} "${XLT_SERVER_HOME}/testmaterials/"*
fi

VARIANT=unknown

if type systemctl > /dev/null 2>&1; then
    echo "Init appears to be systemd"
    VARIANT=systemd
elif type initctl > /dev/null 2>&1; then
    echo "Init appears to be upstart"
    VARIANT=upstart
fi

case $VARIANT in
upstart)
  sed -e "s|@XLT_HOME@|${XLT_SERVER_HOME}|g" "${XLT_SERVER_HOME}/service/unix/xl-testview.conf" > /etc/init/xl-testview.conf
  echo "Installed upstart script: /etc/init/xl-testview.conf"
  ;;
systemd)
  sed -e "s|@XLT_HOME@|${XLT_SERVER_HOME}|g" "${XLT_SERVER_HOME}/service/unix/xl-testview.service" > /lib/systemd/system/xl-testview.service
  systemctl daemon-reload
  systemctl enable xl-testview.service
  echo "Installed systemd script: /lib/systemd/system/xl-testview.service"
  if [ $(echo "$XLT_SERVER_HOME" | wc -w) -ne 1 ]; then
    echo "WARNING: if you installed in a directory with spaces in the name,"
    echo "          ensure systemd is new enough!"
  fi
  ;;
*)
  echo "Did not detect systemd or upstart. Aborting."
  exit 1
  ;;
esac
