# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.hierarchy import *

runs = test_runs.getTestRunsBetween(test_run.testSpecificationName, start_date.getTime(), end_date.getTime())

rotation = -45

passed = []
failed = []
other = []
categories = []
test_durations = []
build_durations = []
have_build_durations = False

for run in runs:
    passed_count = 0
    failed_count = 0
    other_count = 0

    events = test_runs.getEventsForTestRun(run, {'@tags': tags})

    for ev in events:
        if ev.type == 'importFinished':
            build_duration = ev.get('ciBuildDuration')
            have_build_durations = have_build_durations or build_duration > 0
        if is_functional_result(ev):
            result = ev.get('@result')

            if result == 'PASSED':
                passed_count = passed_count + 1
            elif result == 'FAILED':
                failed_count = failed_count + 1
            else:
                other_count = other_count + 1

    # can use the time but spacing on the X becomes funky
    time = run.getStartTime().toString()
    categories.append(time)

    test_durations.append([time, run.getDuration()])
    build_durations.append([time, build_duration])

    passed.append([time, passed_count])
    failed.append([time, failed_count])
    other.append([time, other_count])

graph = {
    'chart': {
        'type': 'column',
        'zoomType': 'x',
        'alignTicks': False
    },
    'title': 'Historical test results',
    'description': 'This report presents the aggregated functional results of a test specification per execution of the test specification in the' +
                   ' time window. The duration of the tests and the total build time is displayed as well.',
    'xAxis': {
        'type': 'category',
        'ordinal': True,
        'labels': {
            'rotation': rotation,
        }
    },
    'yAxis': [{
        'title': {
            'text': 'Number of tests',
            'style': {
                'color': '#666',
                'font-weight': 'normal'
            }
        },
        'min': 0,
        'minTickInterval': 1
    }, {
        'title': {
            'text': 'Duration',
            'style': {
                'color': '#666',
                'font-weight': 'normal'
            }
        },
        'type': 'datetime',
        'labels': {
            'xlt_formatter': 'xlt-duration-formatter',
        },
        'min': 0,
        'minTickInterval': 1,
        'opposite': True
    }
    ],
    'tooltip': {
        'shared': True,
    },
    'legend': {
        'borderColor': None,
        'symbolHeight': 16,
        'symbolWidth': 16
    },
    'plotOptions': {
        'column': {
            'stacking': 'normal',
            'animation': False,
            'borderRadius': 2,
            'groupPadding': 0.1,
            'pointPadding': 0.01
        },
        'series':  {
            'point': {
                'events': {
                    'click': 'url'
                }
            }
        }
    },
    'series': [{
        'name': "Passed",
        'yAxis': 0,
        'data': passed
    }, {
        'name': "Failed",
        'yAxis': 0,
        'data': failed
    }, {
        'name': "Other",
        'yAxis': 0,
        'data': other
    }, {
        'type': 'spline',
        'name': 'Total test duration',
        'yAxis': 1,
        'data': test_durations,
        'marker': {
            'lineWidth': 2,
            'fillColor': 'white'
        },
        'tooltip': {
            'valueSuffix': ' ms'
        }
    }]
}

if have_build_durations:
    graph['series'].append({
        'type': 'spline',
        'name': 'Build duration',
        'yAxis': 1,
        'data': build_durations,
        'marker': {
            'lineWidth': 2,
            'fillColor': 'white'
        },
        'tooltip': {
            'valueSuffix': ' ms'
        }
    })

result_holder.result = graph
