/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.collections.bidimap.AbstractTestBidiMap;
import org.apache.commons.collections.iterators.AbstractTestMapIterator;

public abstract class AbstractTestOrderedBidiMap
extends AbstractTestBidiMap {
    public AbstractTestOrderedBidiMap(String testName) {
        super(testName);
    }

    public AbstractTestOrderedBidiMap() {
    }

    public void testFirstKey() {
        this.resetEmpty();
        OrderedBidiMap bidi = (OrderedBidiMap)this.map;
        try {
            bidi.firstKey();
            AbstractTestOrderedBidiMap.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        this.resetFull();
        bidi = (OrderedBidiMap)this.map;
        Object confirmedFirst = this.confirmed.keySet().iterator().next();
        AbstractTestOrderedBidiMap.assertEquals(confirmedFirst, (Object)bidi.firstKey());
    }

    public void testLastKey() {
        this.resetEmpty();
        OrderedBidiMap bidi = (OrderedBidiMap)this.map;
        try {
            bidi.lastKey();
            AbstractTestOrderedBidiMap.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        this.resetFull();
        bidi = (OrderedBidiMap)this.map;
        Object confirmedLast = null;
        Iterator it = this.confirmed.keySet().iterator();
        while (it.hasNext()) {
            confirmedLast = it.next();
        }
        AbstractTestOrderedBidiMap.assertEquals(confirmedLast, (Object)bidi.lastKey());
    }

    public void testNextKey() {
        this.resetEmpty();
        OrderedBidiMap bidi = (OrderedBidiMap)this.map;
        AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.nextKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.nextKey(null));
            }
            catch (NullPointerException ex) {}
        } else {
            AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.nextKey(null));
        }
        this.resetFull();
        bidi = (OrderedBidiMap)this.map;
        Iterator it = this.confirmed.keySet().iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            AbstractTestOrderedBidiMap.assertEquals(confirmedObject, (Object)bidi.nextKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.nextKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                bidi.nextKey(null);
                AbstractTestOrderedBidiMap.fail();
            }
            catch (NullPointerException ex) {}
        } else {
            AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.nextKey(null));
        }
    }

    public void testPreviousKey() {
        this.resetEmpty();
        OrderedBidiMap bidi = (OrderedBidiMap)this.map;
        AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.previousKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.previousKey(null));
            }
            catch (NullPointerException ex) {}
        } else {
            AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.previousKey(null));
        }
        this.resetFull();
        bidi = (OrderedBidiMap)this.map;
        ArrayList list = new ArrayList(this.confirmed.keySet());
        Collections.reverse(list);
        Iterator it = list.iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            AbstractTestOrderedBidiMap.assertEquals(confirmedObject, (Object)bidi.previousKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.previousKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                bidi.previousKey(null);
                AbstractTestOrderedBidiMap.fail();
            }
            catch (NullPointerException ex) {}
        } else {
            AbstractTestOrderedBidiMap.assertEquals(null, (Object)bidi.previousKey(null));
        }
    }

    public BulkTest bulkTestOrderedMapIterator() {
        return new TestBidiOrderedMapIterator();
    }

    public class TestBidiOrderedMapIterator
    extends AbstractTestMapIterator {
        public TestBidiOrderedMapIterator() {
            super("TestBidiOrderedMapIterator");
        }

        public Object[] addSetValues() {
            return AbstractTestOrderedBidiMap.this.getNewSampleValues();
        }

        public boolean supportsRemove() {
            return AbstractTestOrderedBidiMap.this.isRemoveSupported();
        }

        public boolean supportsSetValue() {
            return AbstractTestOrderedBidiMap.this.isSetValueSupported();
        }

        public MapIterator makeEmptyMapIterator() {
            AbstractTestOrderedBidiMap.this.resetEmpty();
            return ((OrderedBidiMap)AbstractTestOrderedBidiMap.this.map).orderedMapIterator();
        }

        public MapIterator makeFullMapIterator() {
            AbstractTestOrderedBidiMap.this.resetFull();
            return ((OrderedBidiMap)AbstractTestOrderedBidiMap.this.map).orderedMapIterator();
        }

        public Map getMap() {
            return AbstractTestOrderedBidiMap.this.map;
        }

        public Map getConfirmedMap() {
            return AbstractTestOrderedBidiMap.this.confirmed;
        }

        public void verify() {
            super.verify();
            AbstractTestOrderedBidiMap.this.verify();
        }
    }
}

