/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.iterators.AbstractTestMapIterator;

public abstract class AbstractTestOrderedMapIterator
extends AbstractTestMapIterator {
    public AbstractTestOrderedMapIterator(String testName) {
        super(testName);
    }

    public final OrderedMapIterator makeEmptyOrderedMapIterator() {
        return (OrderedMapIterator)this.makeEmptyMapIterator();
    }

    public final OrderedMapIterator makeFullOrderedMapIterator() {
        return (OrderedMapIterator)this.makeFullMapIterator();
    }

    public void testEmptyMapIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        super.testEmptyMapIterator();
        OrderedMapIterator it = this.makeEmptyOrderedMapIterator();
        Map map = this.getMap();
        AbstractTestOrderedMapIterator.assertEquals((boolean)false, (boolean)it.hasPrevious());
        try {
            it.previous();
            AbstractTestOrderedMapIterator.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testFullMapIterator() {
        Object value;
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        super.testFullMapIterator();
        OrderedMapIterator it = this.makeFullOrderedMapIterator();
        Map map = this.getMap();
        AbstractTestOrderedMapIterator.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractTestOrderedMapIterator.assertEquals((boolean)false, (boolean)it.hasPrevious());
        HashSet<Object> set = new HashSet<Object>();
        while (it.hasNext()) {
            key = it.next();
            AbstractTestOrderedMapIterator.assertSame((String)"it.next() should equals getKey()", (Object)key, (Object)it.getKey());
            AbstractTestOrderedMapIterator.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            AbstractTestOrderedMapIterator.assertTrue((String)"Key must be unique", (boolean)set.add(key));
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                AbstractTestOrderedMapIterator.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            AbstractTestOrderedMapIterator.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            AbstractTestOrderedMapIterator.assertEquals((boolean)true, (boolean)it.hasPrevious());
            this.verify();
        }
        while (it.hasPrevious()) {
            key = it.previous();
            AbstractTestOrderedMapIterator.assertSame((String)"it.previous() should equals getKey()", (Object)key, (Object)it.getKey());
            AbstractTestOrderedMapIterator.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            AbstractTestOrderedMapIterator.assertTrue((String)"Key must be unique", (boolean)set.remove(key));
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                AbstractTestOrderedMapIterator.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            AbstractTestOrderedMapIterator.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            AbstractTestOrderedMapIterator.assertEquals((boolean)true, (boolean)it.hasNext());
            this.verify();
        }
    }

    public void testMapIteratorOrder() {
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        OrderedMapIterator it = this.makeFullOrderedMapIterator();
        Map map = this.getMap();
        AbstractTestOrderedMapIterator.assertEquals((String)"keySet() not consistent", new ArrayList(map.keySet()), new ArrayList(map.keySet()));
        Iterator it2 = map.keySet().iterator();
        AbstractTestOrderedMapIterator.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractTestOrderedMapIterator.assertEquals((boolean)true, (boolean)it2.hasNext());
        ArrayList<Object> list = new ArrayList<Object>();
        while (it.hasNext()) {
            key = it.next();
            AbstractTestOrderedMapIterator.assertEquals(it2.next(), (Object)key);
            list.add(key);
        }
        AbstractTestOrderedMapIterator.assertEquals((int)map.size(), (int)list.size());
        while (it.hasPrevious()) {
            key = it.previous();
            AbstractTestOrderedMapIterator.assertEquals(list.get(list.size() - 1), (Object)key);
            list.remove(list.size() - 1);
        }
        AbstractTestOrderedMapIterator.assertEquals((int)0, (int)list.size());
    }
}

