/*
 * Decompiled with CFR 0.152.
 */
package emotionml.xslt;

import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Helpers {
    public static String declaredCategoryVocabulary(Node emotion) {
        return Helpers.declaredVocabulary("category", emotion);
    }

    public static String declaredDimensionVocabulary(Node emotion) {
        return Helpers.declaredVocabulary("dimension", emotion);
    }

    public static String declaredAppraisalVocabulary(Node emotion) {
        return Helpers.declaredVocabulary("appraisal", emotion);
    }

    public static String declaredActionTendencyVocabulary(Node emotion) {
        return Helpers.declaredVocabulary("action-tendency", emotion);
    }

    public static boolean expressedThrough(Node emotionNode, String modality, boolean defaultValue) {
        if (!Helpers.isEmotionMLElement(emotionNode, "emotion")) {
            return false;
        }
        Element emotion = (Element)emotionNode;
        if (!emotion.hasAttribute("expressed-through")) {
            return defaultValue;
        }
        StringTokenizer st = new StringTokenizer(emotion.getAttribute("expressed-through"));
        while (st.hasMoreTokens()) {
            String one = st.nextToken();
            if (!one.equals(modality)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmotionMLElement(Node n, String localName) {
        if (n == null || n.getNodeType() != 1) {
            return false;
        }
        Element e = (Element)n;
        return "http://www.w3.org/2009/10/emotionml".equals(e.getNamespaceURI()) && localName.equals(n.getLocalName());
    }

    private static String declaredVocabulary(String type, Node emotionNode) {
        String attname = type + "-set";
        if (!Helpers.isEmotionMLElement(emotionNode, "emotion")) {
            return "";
        }
        Element emotion = (Element)emotionNode;
        if (emotion.hasAttribute(attname)) {
            return emotion.getAttribute(attname);
        }
        Node parentNode = emotion.getParentNode();
        if (!Helpers.isEmotionMLElement(parentNode, "emotionml")) {
            return "";
        }
        Element parentElement = (Element)parentNode;
        return parentElement.getAttribute(attname);
    }
}

