/*
 * Decompiled with CFR 0.152.
 */
package de.exalta.envers.maven;

import java.util.Collection;
import javax.persistence.Entity;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.tools.hbm2ddl.EnversSchemaGenerator;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Mojo(name="execute", defaultPhase=LifecyclePhase.PACKAGE, configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class SchemaGenerator
extends AbstractMojo {
    private static final String DEFAULT_DESTINATION = "target/schema.sql";
    private Configuration config = new Configuration();
    @Parameter(required=true)
    private String dialect;
    @Parameter(required=true)
    private String packageName;
    @Parameter(defaultValue="target/schema.sql")
    private String destination;

    public void execute() {
        this.getLog().info((CharSequence)("Generating schema for dialect " + this.dialect));
        this.config.setProperty("hibernate.dialect", this.dialect);
        Collection<Class<?>> annotatedClasses = this.getAnnotatedClasses();
        this.getLog().info((CharSequence)(annotatedClasses.size() + " JPA entities found."));
        for (Class<?> c : annotatedClasses) {
            this.config.addAnnotatedClass(c);
        }
        SchemaExport export = new EnversSchemaGenerator(this.config).export();
        export.setDelimiter(";");
        export.setOutputFile(this.destination).execute(true, false, false, true);
        this.getLog().info((CharSequence)("Generated schema saved in " + this.destination));
    }

    private Collection<Class<?>> getAnnotatedClasses() {
        this.getLog().info((CharSequence)("Searching package " + this.packageName + " for JPA entities."));
        Reflections reflections = new Reflections(this.packageName, new Scanner[0]);
        return reflections.getTypesAnnotatedWith(Entity.class);
    }
}

