/*
 * Decompiled with CFR 0.152.
 */
package de.fayard.refreshVersions.core;

import de.fayard.refreshVersions.core.FeatureFlag;
import de.fayard.refreshVersions.core.internal.OutputFile;
import de.fayard.refreshVersions.core.internal.RefreshVersionsConfigHolder;
import de.fayard.refreshVersions.core.internal.SettingsPluginsUpdater;
import de.fayard.refreshVersions.core.internal.VersionsCatalogUpdaterKt;
import de.fayard.refreshVersions.core.internal.versions.VersionsPropertiesModel;
import de.fayard.refreshVersions.core.internal.versions.VersionsPropertiesReadingKt;
import de.fayard.refreshVersions.core.internal.versions.VersionsPropertiesWritingKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007R*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR*\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Lde/fayard/refreshVersions/core/RefreshVersionsCleanupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "value", "Lde/fayard/refreshVersions/core/FeatureFlag;", "disableFlag", "getDisableFlag", "()Lde/fayard/refreshVersions/core/FeatureFlag;", "setDisableFlag", "(Lde/fayard/refreshVersions/core/FeatureFlag;)V", "enableFlag", "getEnableFlag", "setEnableFlag", "cleanUpSettings", "", "cleanUpVersionsCatalog", "cleanUpVersionsProperties", "cleanupKotlinScripts", "refreshVersions-core"})
@SourceDebugExtension(value={"SMAP\nRefreshVersionsCleanupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshVersionsCleanupTask.kt\nde/fayard/refreshVersions/core/RefreshVersionsCleanupTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1549#2:93\n1620#2,3:94\n766#2:97\n857#2,2:98\n1855#2,2:100\n1855#2,2:102\n*S KotlinDebug\n*F\n+ 1 RefreshVersionsCleanupTask.kt\nde/fayard/refreshVersions/core/RefreshVersionsCleanupTask\n*L\n44#1:93\n44#1:94,3\n58#1:97\n58#1:98,2\n60#1:100,2\n71#1:102,2\n*E\n"})
public class RefreshVersionsCleanupTask
extends DefaultTask {
    @Input
    @Optional
    @Option(option="enable", description="Enable a feature flag")
    @Nullable
    private FeatureFlag enableFlag;
    @Input
    @Optional
    @Option(option="disable", description="Disable a feature flag")
    @Nullable
    private FeatureFlag disableFlag;

    @Nullable
    public final FeatureFlag getEnableFlag() {
        return this.enableFlag;
    }

    public final void setEnableFlag(@Nullable FeatureFlag value) {
        this.enableFlag = value;
        if (value != null) {
            FeatureFlag.Companion.getUserSettings().put(value, true);
        }
    }

    @Nullable
    public final FeatureFlag getDisableFlag() {
        return this.disableFlag;
    }

    public final void setDisableFlag(@Nullable FeatureFlag value) {
        this.disableFlag = value;
        if (value != null) {
            FeatureFlag.Companion.getUserSettings().put(value, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void cleanUpVersionsProperties() {
        void $this$mapTo$iv$iv;
        OutputFile.Companion.checkWhichFilesExist();
        VersionsPropertiesModel model = VersionsPropertiesReadingKt.readFromFile(VersionsPropertiesModel.Companion, RefreshVersionsConfigHolder.INSTANCE.getVersionsPropertiesFile());
        Iterable $this$map$iv = model.getSections();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VersionsPropertiesModel.Section section;
            void section2;
            VersionsPropertiesModel.Section section3 = (VersionsPropertiesModel.Section)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = section2;
            if (var12_11 instanceof VersionsPropertiesModel.Section.Comment) {
                section = section2;
            } else if (var12_11 instanceof VersionsPropertiesModel.Section.VersionEntry) {
                section = VersionsPropertiesModel.Section.VersionEntry.copy$default((VersionsPropertiesModel.Section.VersionEntry)section2, null, null, null, CollectionsKt.emptyList(), null, 23, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(section);
        }
        List sectionsWithoutAvailableUpdates = (List)destination$iv$iv;
        VersionsPropertiesModel newModel = VersionsPropertiesModel.copy$default(model, null, null, null, sectionsWithoutAvailableUpdates, 7, null);
        VersionsPropertiesWritingKt.writeTo(newModel, RefreshVersionsConfigHolder.INSTANCE.getVersionsPropertiesFile());
        OutputFile.logFileWasModified$default(OutputFile.VERSIONS_PROPERTIES, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void cleanUpSettings() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = OutputFile.Companion.getSettingsFiles();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OutputFile it = (OutputFile)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.getExisted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List settingsFiles = (List)destination$iv$iv;
        Iterable $this$forEach$iv = settingsFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String newContent;
            StringBuilder stringBuilder;
            OutputFile settingsFile = (OutputFile)((Object)element$iv);
            boolean bl = false;
            String initialContent = settingsFile.readText();
            StringBuilder $this$cleanUpSettings_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$cleanUpSettings_u24lambda_u243_u24lambda_u242.append(initialContent);
            SettingsPluginsUpdater.INSTANCE.removeCommentsAddedByUs$refreshVersions_core($this$cleanUpSettings_u24lambda_u243_u24lambda_u242);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"toString(...)");
            if (initialContent.length() == newContent.length()) continue;
            OutputFile.writeText$default(settingsFile, newContent, false, 2, null);
        }
        $this$forEach$iv = settingsFiles;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OutputFile it = (OutputFile)((Object)element$iv);
            boolean bl = false;
            OutputFile.logFileWasModified$default(it, false, 1, null);
        }
    }

    @TaskAction
    public final void cleanUpVersionsCatalog() {
        File file;
        if (FeatureFlag.VERSIONS_CATALOG.isEnabled() && (file = new File("gradle/libs.versions.toml")).exists()) {
            VersionsCatalogUpdaterKt.VersionsCatalogUpdater(file, CollectionsKt.emptyList()).cleanupComments(file);
            OutputFile.logFileWasModified$default(OutputFile.GRADLE_VERSIONS_CATALOG, false, 1, null);
        }
    }

    @TaskAction
    public final void cleanupKotlinScripts() {
        if (FeatureFlag.KOTLIN_SCRIPTS.isEnabled()) {
            System.out.println((Object)"NOTE: refreshVersionsCleanUp doesn't clean up Kotlin Scripts yet, see https://github.com/Splitties/refreshVersions/issues/582");
        }
    }
}

