/*
 * Decompiled with CFR 0.152.
 */
package de.fayard.refreshVersions.core;

import de.fayard.refreshVersions.core.StabilityLevel;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Incubating;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Incubating
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0087\b\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0010*\u00020\u00032\u0006\u0010 \u001a\u00020\fH\u0002R%\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\u000b\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lde/fayard/refreshVersions/core/Version;", "", "value", "", "(Ljava/lang/String;)V", "comparableList", "", "getComparableList", "()Ljava/util/List;", "comparableList$delegate", "Lkotlin/Lazy;", "isRange", "", "()Z", "isRange$delegate", "stabilityLevel", "Lde/fayard/refreshVersions/core/StabilityLevel;", "getStabilityLevel", "()Lde/fayard/refreshVersions/core/StabilityLevel;", "stabilityLevel$delegate", "getValue", "()Ljava/lang/String;", "compareTo", "", "other", "component1", "copy", "equals", "", "hashCode", "toString", "findStabilityLevel", "fullVersion", "Companion", "refreshVersions-core"})
public final class Version
implements Comparable<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final Lazy stabilityLevel$delegate;
    @NotNull
    private final Lazy isRange$delegate;
    @NotNull
    private final Lazy comparableList$delegate;
    @NotNull
    private static final Regex npmRangeCharsRegex = new Regex("[<=>^~*]|\\.x");
    @NotNull
    private static final Comparator<Version> versionComparator = new Comparator<Version>(){

        /*
         * Enabled aggressive block sorting
         */
        public int compare(@NotNull Version o1, @NotNull Version o2) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            if (Intrinsics.areEqual((Object)o1, (Object)o2)) {
                return 0;
            }
            List v1 = Version.access$getComparableList(o1);
            List v2 = Version.access$getComparableList(o2);
            int i2 = 0;
            int lastCommonIndex = Math.min(CollectionsKt.getLastIndex((List)v1), CollectionsKt.getLastIndex((List)v2));
            if (i2 <= lastCommonIndex) {
                while (true) {
                    block21: {
                        int comparison;
                        Comparable e1 = (Comparable)v1.get(i2);
                        Comparable e2 = (Comparable)v2.get(i2);
                        Comparable comparable = e1;
                        if (comparable instanceof BigInteger) {
                            if (e2 instanceof BigInteger) {
                                comparison = ((BigInteger)e1).compareTo((BigInteger)e2);
                                if (comparison != 0) {
                                    return comparison;
                                }
                                break block21;
                            } else {
                                if (e2 instanceof StabilityLevel || e2 instanceof String) return 1;
                                String string3 = "Check failed.";
                                throw new IllegalStateException(string3.toString());
                            }
                        }
                        if (comparable instanceof String) {
                            if (e2 instanceof String) {
                                comparison = ((String)((Object)e1)).compareTo((String)((Object)e2));
                                if (comparison != 0) {
                                    return comparison;
                                }
                                break block21;
                            } else {
                                if (e2 instanceof BigInteger) {
                                    return -1;
                                }
                                if (e2 instanceof StabilityLevel) return -1;
                                String string4 = "Check failed.";
                                throw new IllegalStateException(string4.toString());
                            }
                        }
                        if (!(e1 instanceof StabilityLevel)) {
                            String string5 = "Check failed.";
                            throw new IllegalStateException(string5.toString());
                        }
                        if (e2 instanceof StabilityLevel) {
                            comparison = Version.access$getReverseStabilityComparator$cp().compare(e1, e2);
                            if (comparison != 0) {
                                return comparison;
                            }
                        } else {
                            if (e2 instanceof BigInteger) {
                                return -1;
                            }
                            if (e2 instanceof String) return 1;
                            String string6 = "Check failed.";
                            throw new IllegalStateException(string6.toString());
                        }
                    }
                    if (i2 == lastCommonIndex) break;
                    ++i2;
                }
            }
            if (CollectionsKt.getLastIndex((List)v1) > lastCommonIndex) {
                Comparable e1 = (Comparable)v1.get(lastCommonIndex + 1);
                if (e1 instanceof BigInteger) return 1;
                if (e1 instanceof String) {
                    return 1;
                }
                if (e1 instanceof StabilityLevel) return -1;
                string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            if (CollectionsKt.getLastIndex((List)v2) <= lastCommonIndex) {
                int n = o1.getValue().compareTo(o2.getValue());
                return n;
            }
            Comparable e2 = (Comparable)v2.get(lastCommonIndex + 1);
            if (e2 instanceof BigInteger) return -1;
            if (e2 instanceof String) {
                return -1;
            }
            if (e2 instanceof StabilityLevel) return 1;
            string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
    };
    @NotNull
    private static final Comparator<StabilityLevel> reverseStabilityComparator = new Comparator(){

        public final int compare(T a, T b) {
            StabilityLevel it = (StabilityLevel)((Object)b);
            boolean bl = false;
            Comparable comparable = (Comparable)((Object)it);
            it = (StabilityLevel)((Object)a);
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it)));
        }
    };
    @NotNull
    private static final List<String> knownStableKeywords;
    @NotNull
    private static final Regex digitsOnlyBasedVersionNumberRegex;

    public Version(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.stabilityLevel$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<StabilityLevel>(this){
            final /* synthetic */ Version this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final StabilityLevel invoke() {
                StabilityLevel stabilityLevel2 = Version.access$findStabilityLevel(this.this$0, this.this$0.getValue(), true);
                if (stabilityLevel2 == null) {
                    stabilityLevel2 = StabilityLevel.Stable;
                }
                return stabilityLevel2;
            }
        }));
        this.isRange$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Version this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return de.fayard.refreshVersions.core.Version$Companion.access$isRange(Version.Companion, this.this$0.getValue());
            }
        }));
        this.comparableList$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)new Function0<List<? extends Comparable<?>>>(this){
            final /* synthetic */ Version this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Comparable<?>> invoke() {
                return de.fayard.refreshVersions.core.Version$Companion.access$toComparableList(Version.Companion, this.this$0);
            }
        });
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final StabilityLevel getStabilityLevel() {
        Lazy lazy = this.stabilityLevel$delegate;
        return (StabilityLevel)((Object)lazy.getValue());
    }

    private final StabilityLevel findStabilityLevel(String $this$findStabilityLevel, boolean fullVersion) {
        return StringsKt.contains$default((CharSequence)$this$findStabilityLevel, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null) ? StabilityLevel.Snapshot : (Version.findStabilityLevel$matches$default($this$findStabilityLevel, fullVersion, "preview", false, false, 12, null) ? StabilityLevel.Preview : (Version.findStabilityLevel$matches$default($this$findStabilityLevel, fullVersion, "dev", false, false, 12, null) ? StabilityLevel.Development : (Version.findStabilityLevel$matches$default($this$findStabilityLevel, fullVersion, "alpha", false, false, 12, null) ? StabilityLevel.Alpha : (Version.findStabilityLevel$matches$default($this$findStabilityLevel, fullVersion, "beta", false, false, 12, null) ? StabilityLevel.Beta : (Version.findStabilityLevel$matches$default($this$findStabilityLevel, fullVersion, "eap", false, false, 12, null) ? StabilityLevel.EarlyAccessProgram : (Version.findStabilityLevel$matches$default($this$findStabilityLevel, fullVersion, "M", true, false, 8, null) ? StabilityLevel.Milestone : (Version.findStabilityLevel$matches$default($this$findStabilityLevel, fullVersion, "RC", false, false, 12, null) ? StabilityLevel.ReleaseCandidate : (Version.Companion.isDefinitelyStable($this$findStabilityLevel) ? StabilityLevel.Stable : null))))))));
    }

    public final boolean isRange() {
        Lazy lazy = this.isRange$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return versionComparator.compare(this, other);
    }

    private final List<Comparable<?>> getComparableList() {
        Lazy lazy = this.comparableList$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final Version copy(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new Version(value);
    }

    public static /* synthetic */ Version copy$default(Version version, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = version.value;
        }
        return version.copy(string2);
    }

    @NotNull
    public String toString() {
        return "Version(value=" + this.value + ')';
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version = (Version)other;
        return Intrinsics.areEqual((Object)this.value, (Object)version.value);
    }

    private static final boolean findStabilityLevel$matches(String $this$findStabilityLevel_u24matches, boolean $fullVersion, String kind, boolean requireNumber, boolean ignoreCase) {
        return Version.Companion.isStabilityLevel(kind, ignoreCase, requireNumber, !$fullVersion, $this$findStabilityLevel_u24matches);
    }

    static /* synthetic */ boolean findStabilityLevel$matches$default(String string2, boolean bl, String string3, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return Version.findStabilityLevel$matches(string2, bl, string3, bl2, bl3);
    }

    public static final /* synthetic */ StabilityLevel access$findStabilityLevel(Version $this, String $receiver, boolean fullVersion) {
        return $this.findStabilityLevel($receiver, fullVersion);
    }

    public static final /* synthetic */ List access$getComparableList(Version $this) {
        return $this.getComparableList();
    }

    public static final /* synthetic */ Comparator access$getReverseStabilityComparator$cp() {
        return reverseStabilityComparator;
    }

    static {
        Object[] objectArray = new String[]{"RELEASE", "FINAL", "GA"};
        knownStableKeywords = CollectionsKt.listOf((Object[])objectArray);
        digitsOnlyBasedVersionNumberRegex = new Regex("^[0-9,.v-]+$");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J2\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\f\u0010\u0017\u001a\u00020\u0010*\u00020\u0007H\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006*\u00020\u0007H\u0002J\u0016\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0006*\u00020\u000eH\u0002J\f\u0010\u001b\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\nj\b\u0012\u0004\u0012\u00020\u000e`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/fayard/refreshVersions/core/Version$Companion;", "", "()V", "digitsOnlyBasedVersionNumberRegex", "Lkotlin/text/Regex;", "knownStableKeywords", "", "", "npmRangeCharsRegex", "reverseStabilityComparator", "Ljava/util/Comparator;", "Lde/fayard/refreshVersions/core/StabilityLevel;", "Lkotlin/Comparator;", "versionComparator", "Lde/fayard/refreshVersions/core/Version;", "isDefinitelyStable", "", "version", "isStabilityLevel", "stabilityLevelMarker", "ignoreCase", "requireNumber", "isFragment", "isRange", "rangeComponents", "toComparableList", "", "withoutKnownStableKeywords", "refreshVersions-core"})
    @SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\nde/fayard/refreshVersions/core/Version$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1747#2,3:209\n766#2:213\n857#2,2:214\n1549#2:216\n1620#2,3:217\n1360#2:220\n1446#2,5:221\n1#3:212\n*S KotlinDebug\n*F\n+ 1 Version.kt\nde/fayard/refreshVersions/core/Version$Companion\n*L\n139#1:209,3\n177#1:213\n177#1:214,2\n178#1:216\n178#1:217,3\n187#1:220\n187#1:221,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isDefinitelyStable(String version) {
            boolean bl;
            block3: {
                String string2 = version.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                String uppercaseVersion = string2;
                Iterable $this$any$iv = knownStableKeywords;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)uppercaseVersion, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean hasStableKeyword = bl;
            return hasStableKeyword || digitsOnlyBasedVersionNumberRegex.matches((CharSequence)version);
        }

        private final boolean isStabilityLevel(String stabilityLevelMarker, boolean ignoreCase, boolean requireNumber, boolean isFragment, String version) {
            boolean bl;
            int indexOfStabilityLevelMarker = StringsKt.indexOf$default((CharSequence)version, (String)stabilityLevelMarker, (int)0, (boolean)ignoreCase, (int)2, null);
            if (indexOfStabilityLevelMarker == -1) {
                bl = false;
            } else {
                boolean bl2;
                Character c = StringsKt.getOrNull((CharSequence)version, (int)(indexOfStabilityLevelMarker + stabilityLevelMarker.length()));
                if (c != null) {
                    char it = c.charValue();
                    boolean bl3 = false;
                    bl2 = Character.isDigit(it) || it == '-';
                } else {
                    bl2 = isFragment;
                }
                bl = bl2 || !requireNumber;
            }
            return bl;
        }

        static /* synthetic */ boolean isStabilityLevel$default(Companion companion, String string2, boolean bl, boolean bl2, boolean bl3, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.isStabilityLevel(string2, bl, bl2, bl3, string3);
        }

        private final boolean isRange(String $this$isRange) {
            if (((CharSequence)$this$isRange).length() == 0) {
                return false;
            }
            String npmOperators = "^~*";
            String yarnOperators = "<>=";
            String firstCharOperators = npmOperators + yarnOperators;
            return StringsKt.contains$default((CharSequence)firstCharOperators, (char)StringsKt.first((CharSequence)$this$isRange), (boolean)false, (int)2, null) ? true : (StringsKt.contains$default((CharSequence)$this$isRange, (CharSequence)" - ", (boolean)false, (int)2, null) ? true : (StringsKt.contains$default((CharSequence)$this$isRange, (CharSequence)" || ", (boolean)false, (int)2, null) ? true : StringsKt.contains$default((CharSequence)$this$isRange, (CharSequence)".x", (boolean)false, (int)2, null)));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Version> rangeComponents(String $this$rangeComponents) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            String[] stringArray = (String[])$this$rangeComponents;
            Regex regex = npmRangeCharsRegex;
            Object object = "";
            CharSequence charSequence = regex.replace((CharSequence)stringArray, (String)object);
            stringArray = new String[]{" - ", " || ", " "};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Version(it));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Comparable<?>> toComparableList(Version $this$toComparableList) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            if ($this$toComparableList.isRange()) {
                Version version = (Version)CollectionsKt.minOrNull((Iterable)this.rangeComponents($this$toComparableList.getValue()));
                if (version == null) {
                    throw new IllegalStateException(("no lower version bound found in range: '" + $this$toComparableList.getValue() + '\'').toString());
                }
                Version lowerBound = version;
                return this.toComparableList(lowerBound);
            }
            Object lowerBound = new String[]{".", "-"};
            lowerBound = StringsKt.split$default((CharSequence)this.withoutKnownStableKeywords($this$toComparableList.getValue()), (String[])lowerBound, (boolean)false, (int)0, (int)6, null);
            Function1 transform$iv = (Function1)new Function1<String, List<? extends Object>>($this$toComparableList){
                final /* synthetic */ Version $this_toComparableList;
                {
                    this.$this_toComparableList = $receiver;
                    super(1);
                }

                @NotNull
                public final List<Object> invoke(@NotNull String it) {
                    Object object;
                    block10: {
                        block9: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            object = StringsKt.toBigIntegerOrNull((String)it);
                            if (object == null) break block9;
                            BigInteger number = object;
                            boolean bl = false;
                            List list = CollectionsKt.listOf((Object)number);
                            object = list;
                            if (list != null) break block10;
                        }
                        StabilityLevel stabilityLevel2 = Version.access$findStabilityLevel(this.$this_toComparableList, it, false);
                        if (stabilityLevel2 != null) {
                            int indexOfLastNonDigit;
                            StabilityLevel level;
                            block8: {
                                int n;
                                level = stabilityLevel2;
                                boolean bl = false;
                                CharSequence $this$indexOfLast$iv = it;
                                boolean $i$f$indexOfLast = false;
                                int n2 = $this$indexOfLast$iv.length() + -1;
                                if (0 <= n2) {
                                    do {
                                        int index$iv = n2--;
                                        char c = $this$indexOfLast$iv.charAt(index$iv);
                                        boolean bl2 = false;
                                        boolean bl3 = !Character.isDigit(c);
                                        if (!bl3) continue;
                                        n = index$iv;
                                        break block8;
                                    } while (0 <= n2);
                                }
                                n = indexOfLastNonDigit = -1;
                            }
                            if (indexOfLastNonDigit == -1 || indexOfLastNonDigit == StringsKt.getLastIndex((CharSequence)it)) {
                                object = CollectionsKt.listOf((Object)((Object)level));
                            } else {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = level;
                                String string2 = it.substring(indexOfLastNonDigit + 1);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                                objectArray[1] = new BigInteger(string2);
                                object = CollectionsKt.listOf((Object[])objectArray);
                            }
                        } else {
                            object = CollectionsKt.listOf((Object)it);
                        }
                    }
                    return object;
                }
            };
            boolean $i$f$flatMap = false;
            void var5_6 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Iterable list$iv$iv = (Iterable)transform$iv.invoke(element$iv$iv);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final String withoutKnownStableKeywords(String $this$withoutKnownStableKeywords) {
            String result2 = $this$withoutKnownStableKeywords;
            for (String suffix : knownStableKeywords) {
                result2 = StringsKt.replace$default((String)result2, (String)suffix, (String)"", (boolean)false, (int)4, null);
            }
            return result2;
        }

        public static final /* synthetic */ boolean access$isRange(Companion $this, String $receiver) {
            return $this.isRange($receiver);
        }

        public static final /* synthetic */ List access$toComparableList(Companion $this, Version $receiver) {
            return $this.toComparableList($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

