/*
 * Decompiled with CFR 0.152.
 */
package de.fayard.refreshVersions.core.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\u001f\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0082\b\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000e\u001a\u00020\t*\u00020\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\t*\u00020\u000fH\u0000\u001a\f\u0010\u0011\u001a\u00020\t*\u00020\u000fH\u0000\u00a8\u0006\u0012"}, d2={"checkArtifactPatternIsValid", "", "artifactPattern", "", "checkGroupAndName", "group", "name", "checkOrReport", "condition", "", "errorMessage", "Lkotlin/Function0;", "checkVersionKeyPatternIsValid", "aliasRule", "isAllowedInMavenGroup", "", "isAllowedInMavenName", "isWordPart", "refreshVersions-core"})
@SourceDebugExtension(value={"SMAP\nArtifactVersionKeyRulesChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactVersionKeyRulesChecks.kt\nde/fayard/refreshVersions/core/internal/ArtifactVersionKeyRulesChecksKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,141:1\n137#1,2:148\n137#1,2:156\n137#1,2:161\n137#1,2:163\n137#1,2:165\n137#1,2:167\n137#1,2:169\n137#1,2:171\n137#1,2:173\n137#1,2:175\n137#1,2:177\n137#1,2:179\n137#1,2:187\n137#1,2:189\n137#1,2:191\n151#2,6:142\n151#2,6:150\n1099#2,3:158\n151#2,6:181\n*S KotlinDebug\n*F\n+ 1 ArtifactVersionKeyRulesChecks.kt\nde/fayard/refreshVersions/core/internal/ArtifactVersionKeyRulesChecksKt\n*L\n11#1:148,2\n18#1:156,2\n31#1:161,2\n40#1:163,2\n44#1:165,2\n62#1:167,2\n68#1:169,2\n76#1:171,2\n82#1:173,2\n90#1:175,2\n96#1:177,2\n104#1:179,2\n121#1:187,2\n127#1:189,2\n130#1:191,2\n10#1:142,6\n17#1:150,6\n31#1:158,3\n118#1:181,6\n*E\n"})
public final class ArtifactVersionKeyRulesChecksKt {
    public static final boolean isAllowedInMavenGroup(char $this$isAllowedInMavenGroup) {
        return Character.isLetterOrDigit($this$isAllowedInMavenGroup) || StringsKt.contains$default((CharSequence)"._-", (char)$this$isAllowedInMavenGroup, (boolean)false, (int)2, null);
    }

    public static final boolean isAllowedInMavenName(char $this$isAllowedInMavenName) {
        return Character.isLetterOrDigit($this$isAllowedInMavenName) || StringsKt.contains$default((CharSequence)"._-", (char)$this$isAllowedInMavenName, (boolean)false, (int)2, null);
    }

    public static final boolean isWordPart(char $this$isWordPart) {
        return Character.isLetterOrDigit($this$isWordPart) || $this$isWordPart == '_';
    }

    public static final void checkGroupAndName(@NotNull String group, @NotNull String name) {
        int n;
        boolean $i$f$checkOrReport;
        int condition$iv;
        int indexOfFirstInvalidChar;
        block5: {
            int n2;
            char it;
            int index$iv;
            boolean $i$f$indexOfFirst;
            CharSequence $this$indexOfFirst$iv;
            block4: {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                $this$indexOfFirst$iv = group;
                $i$f$indexOfFirst = false;
                int n3 = $this$indexOfFirst$iv.length();
                for (index$iv = 0; index$iv < n3; ++index$iv) {
                    it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!ArtifactVersionKeyRulesChecksKt.isAllowedInMavenGroup(it))) continue;
                    n2 = index$iv;
                    break block4;
                }
                n2 = -1;
            }
            indexOfFirstInvalidChar = n2;
            boolean bl = false;
            condition$iv = indexOfFirstInvalidChar == -1 ? 1 : 0;
            $i$f$checkOrReport = false;
            if (condition$iv == 0) {
                boolean bl2 = false;
                char invalidChar = group.charAt(indexOfFirstInvalidChar);
                String string2 = "The given artifact group is invalid. Only letters, digits and dots (.) are allowed, but at column " + (indexOfFirstInvalidChar + 1) + ", the following character has been found: " + invalidChar;
                throw new IllegalArgumentException(string2);
            }
            $this$indexOfFirst$iv = name;
            $i$f$indexOfFirst = false;
            condition$iv = $this$indexOfFirst$iv.length();
            for (index$iv = 0; index$iv < condition$iv; ++index$iv) {
                it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl3 = false;
                if (!(!ArtifactVersionKeyRulesChecksKt.isAllowedInMavenName(it))) continue;
                n = index$iv;
                break block5;
            }
            n = -1;
        }
        indexOfFirstInvalidChar = n;
        boolean bl = false;
        condition$iv = indexOfFirstInvalidChar == -1 ? 1 : 0;
        $i$f$checkOrReport = false;
        if (condition$iv == 0) {
            boolean bl4 = false;
            char invalidChar = group.charAt(indexOfFirstInvalidChar);
            String string3 = "The given artifact name is invalid. Only letters, digits and dots (.) are allowed, but at column " + (indexOfFirstInvalidChar + 1) + ", the following character has been found: " + invalidChar;
            throw new IllegalArgumentException(string3);
        }
    }

    public static final void checkArtifactPatternIsValid(@NotNull String artifactPattern) {
        Intrinsics.checkNotNullParameter((Object)artifactPattern, (String)"artifactPattern");
        CharSequence $this$count$iv = artifactPattern;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it == ':')) continue;
            ++count$iv;
        }
        boolean condition$iv = count$iv <= 1;
        boolean $i$f$checkOrReport = false;
        if (!condition$iv) {
            boolean bl = false;
            String string2 = "The following artifact pattern is invalid: " + artifactPattern + ".\nAt most one column character (':') is allowed.";
            throw new IllegalArgumentException(string2);
        }
        int i2 = 0;
        while (i2 <= StringsKt.getLastIndex((CharSequence)artifactPattern)) {
            char nextChar;
            boolean $i$f$checkOrReport2;
            boolean condition$iv2;
            boolean $i$f$checkOrReport3;
            int condition$iv3;
            char c = artifactPattern.charAt(i2);
            if (c == '?') {
                String wordPlaceholder = "???";
                int indexOfVariablePart = StringsKt.indexOf$default((CharSequence)artifactPattern, (String)wordPlaceholder, (int)i2, (boolean)false, (int)4, null);
                condition$iv3 = i2 == indexOfVariablePart ? 1 : 0;
                $i$f$checkOrReport3 = false;
                if (condition$iv3 == 0) {
                    boolean bl = false;
                    String string3 = artifactPattern.substring(i2, i2 + wordPlaceholder.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String found = string3;
                    String string4 = "Expected " + wordPlaceholder + " but found " + found;
                    throw new IllegalArgumentException(string4);
                }
                condition$iv3 = StringsKt.indexOf$default((CharSequence)artifactPattern, (String)"????", (int)i2, (boolean)false, (int)4, null) == -1 ? 1 : 0;
                $i$f$checkOrReport3 = false;
                if (condition$iv3 == 0) {
                    boolean bl = false;
                    String string5 = "The word placeholder is 3 question marks (" + wordPlaceholder + ") but more have been found.";
                    throw new IllegalArgumentException(string5);
                }
                i2 += wordPlaceholder.length();
                continue;
            }
            if (c == '(' ? true : c == ')') {
                int wordPlaceholder = i2;
                i2 = wordPlaceholder + 1;
                continue;
            }
            if (c == '*') {
                if (i2 == StringsKt.getLastIndex((CharSequence)artifactPattern)) {
                    return;
                }
                i2 += i2 == StringsKt.indexOf$default((CharSequence)artifactPattern, (String)"*:", (int)i2, (boolean)false, (int)4, null) ? 2 : 1;
                continue;
            }
            if (c == '.') {
                condition$iv2 = i2 != StringsKt.getLastIndex((CharSequence)artifactPattern);
                $i$f$checkOrReport2 = false;
                if (!condition$iv2) {
                    boolean bl = false;
                    String string6 = "The following artifact pattern is invalid: " + artifactPattern + ".\nAn artifact pattern cannot end with a dot.";
                    throw new IllegalArgumentException(string6);
                }
                nextChar = artifactPattern.charAt(i2 + 1);
                String specialCharsAllowedNext = "?*";
                condition$iv3 = Character.isLetterOrDigit(nextChar) || StringsKt.contains$default((CharSequence)specialCharsAllowedNext, (char)nextChar, (boolean)false, (int)2, null) ? 1 : 0;
                $i$f$checkOrReport3 = false;
                if (condition$iv3 == 0) {
                    boolean bl = false;
                    String string7 = "The following artifact pattern is invalid: " + artifactPattern + ".\nOnly letters, digits and the following characters are allowed after a dot: " + specialCharsAllowedNext;
                    throw new IllegalArgumentException(string7);
                }
                condition$iv3 = i2;
                i2 = condition$iv3 + 1;
                continue;
            }
            if (c == '-') {
                condition$iv2 = i2 != StringsKt.getLastIndex((CharSequence)artifactPattern);
                $i$f$checkOrReport2 = false;
                if (!condition$iv2) {
                    boolean bl = false;
                    String string8 = "The following artifact pattern is invalid: " + artifactPattern + ".\nAn artifact pattern cannot end with a dash (-).";
                    throw new IllegalArgumentException(string8);
                }
                nextChar = artifactPattern.charAt(i2 + 1);
                String specialCharsAllowedNext = "?*";
                condition$iv3 = Character.isLetterOrDigit(nextChar) || StringsKt.contains$default((CharSequence)specialCharsAllowedNext, (char)nextChar, (boolean)false, (int)2, null) ? 1 : 0;
                $i$f$checkOrReport3 = false;
                if (condition$iv3 == 0) {
                    boolean bl = false;
                    String string9 = "The following artifact pattern is invalid: " + artifactPattern + ".\nOnly letters, digits and the following characters are allowed after a dot: " + specialCharsAllowedNext;
                    throw new IllegalArgumentException(string9);
                }
                condition$iv3 = i2;
                i2 = condition$iv3 + 1;
                continue;
            }
            if (c == ':') {
                condition$iv2 = i2 != StringsKt.getLastIndex((CharSequence)artifactPattern);
                $i$f$checkOrReport2 = false;
                if (!condition$iv2) {
                    boolean bl = false;
                    String string10 = "The following artifact pattern is invalid: " + artifactPattern + ".\nAn artifact pattern cannot end with a column (:).";
                    throw new IllegalArgumentException(string10);
                }
                nextChar = artifactPattern.charAt(i2 + 1);
                String specialCharsAllowedNext = "?*";
                condition$iv3 = Character.isLetterOrDigit(nextChar) || StringsKt.contains$default((CharSequence)specialCharsAllowedNext, (char)nextChar, (boolean)false, (int)2, null) ? 1 : 0;
                $i$f$checkOrReport3 = false;
                if (condition$iv3 == 0) {
                    boolean bl = false;
                    String string11 = "The following artifact pattern is invalid: " + artifactPattern + ".\nOnly letters, digits and the following characters are allowed after a dot: " + specialCharsAllowedNext;
                    throw new IllegalArgumentException(string11);
                }
                condition$iv3 = i2;
                i2 = condition$iv3 + 1;
                continue;
            }
            condition$iv2 = ArtifactVersionKeyRulesChecksKt.isWordPart(c);
            $i$f$checkOrReport2 = false;
            if (!condition$iv2) {
                boolean bl = false;
                String allowedNonAlphanumericChars = ".:?(-*)";
                String string12 = "The following artifact pattern is invalid: " + artifactPattern + ".\nCharacter at column " + (i2 + 1) + " (" + c + ") is not allowed. Only letters, digits and the following special characters are allowed: " + allowedNonAlphanumericChars;
                throw new IllegalArgumentException(string12);
            }
            int n = i2;
            i2 = n + 1;
        }
    }

    public static final void checkVersionKeyPatternIsValid(@NotNull String aliasRule) {
        int n;
        String allowedChars;
        block4: {
            Intrinsics.checkNotNullParameter((Object)aliasRule, (String)"aliasRule");
            allowedChars = "^. ";
            CharSequence $this$indexOfFirst$iv = aliasRule;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char c = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!StringsKt.contains$default((CharSequence)allowedChars, (char)c, (boolean)false, (int)2, null))) continue;
                n = index$iv;
                break block4;
            }
            n = -1;
        }
        int indexOfFirstInvalidChar = n;
        boolean condition$iv = indexOfFirstInvalidChar == -1;
        boolean $i$f$checkOrReport = false;
        if (!condition$iv) {
            boolean bl = false;
            char invalidChar = aliasRule.charAt(indexOfFirstInvalidChar);
            String string2 = "The following alias rule is invalid: " + aliasRule + "\nCharacter at column " + (indexOfFirstInvalidChar + 1) + " (" + invalidChar + ") is not allowed. Only the following characters are allowed: " + allowedChars;
            throw new IllegalArgumentException(string2);
        }
        condition$iv = !StringsKt.contains$default((CharSequence)aliasRule, (CharSequence)"..", (boolean)false, (int)2, null);
        $i$f$checkOrReport = false;
        if (!condition$iv) {
            boolean bl = false;
            String string3 = "Contiguous dots (..) is reserved for full maven coordinates keys.";
            throw new IllegalArgumentException(string3);
        }
        condition$iv = !StringsKt.contains$default((CharSequence)aliasRule, (CharSequence)" .", (boolean)false, (int)2, null);
        $i$f$checkOrReport = false;
        if (!condition$iv) {
            boolean bl = false;
            String string4 = "The following alias rule is invalid: " + aliasRule + "\nDot cannot be preceded by a space. Put it immediately after the ^ character.";
            throw new IllegalArgumentException(string4);
        }
    }

    private static final void checkOrReport(boolean condition, Function0<String> errorMessage) {
        boolean $i$f$checkOrReport = false;
        if (!condition) {
            throw new IllegalArgumentException((String)errorMessage.invoke());
        }
    }
}

