/*
 * Decompiled with CFR 0.152.
 */
package de.fayard.refreshVersions.core.internal;

import de.fayard.refreshVersions.core.extensions.dom.NodeListKt;
import de.fayard.refreshVersions.core.extensions.text.StringKt;
import de.fayard.refreshVersions.core.internal.LintUpdatingIssue;
import de.fayard.refreshVersions.core.internal.problems.Problem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.initialization.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a8\u0010\u0000\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u0002H\u0000\u001a0\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\rH\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"attemptGettingLintXmlWithMissingRules", "Lkotlin/Pair;", "", "", "Lde/fayard/refreshVersions/core/internal/problems/Problem;", "Lde/fayard/refreshVersions/core/internal/LintUpdatingIssue;", "lintFile", "Ljava/io/File;", "lintXmlContent", "configureLintIfRunningOnAnAndroidProject", "settings", "Lorg/gradle/api/initialization/Settings;", "versionsMap", "", "hasAttribute", "", "Lorg/w3c/dom/Element;", "name", "expectedValue", "isIssue", "id", "refreshVersions-core"})
@SourceDebugExtension(value={"SMAP\nLintUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintUpdater.kt\nde/fayard/refreshVersions/core/internal/LintUpdaterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n288#2,2:160\n*S KotlinDebug\n*F\n+ 1 LintUpdater.kt\nde/fayard/refreshVersions/core/internal/LintUpdaterKt\n*L\n104#1:160,2\n*E\n"})
public final class LintUpdaterKt {
    @NotNull
    public static final List<Problem<LintUpdatingIssue>> configureLintIfRunningOnAnAndroidProject(@NotNull Settings settings, @NotNull Map<String, String> versionsMap) {
        List problems;
        block1: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter(versionsMap, (String)"versionsMap");
            if (!versionsMap.containsKey("plugin.android")) {
                return CollectionsKt.emptyList();
            }
            File file = settings.getRootDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"settings.rootDir");
            File lintFile = FilesKt.resolve((File)file, (String)"lint.xml");
            Pair pair = LintUpdaterKt.attemptGettingLintXmlWithMissingRules$default(lintFile, null, 2, null);
            String newXml = (String)pair.component1();
            problems = (List)pair.component2();
            String string2 = newXml;
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            FilesKt.writeText$default((File)lintFile, (String)it, null, (int)2, null);
        }
        return problems;
    }

    @NotNull
    public static final Pair<String, List<Problem<LintUpdatingIssue>>> attemptGettingLintXmlWithMissingRules(@Nullable File lintFile, @NotNull String lintXmlContent) {
        StringBuilder stringBuilder;
        Object $i$a$-runCatching-LintUpdaterKt$attemptGettingLintXmlWithMissingRules$document$22;
        Intrinsics.checkNotNullParameter((Object)lintXmlContent, (String)"lintXmlContent");
        if (StringsKt.isBlank((CharSequence)lintXmlContent)) {
            return TuplesKt.to((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lint>\n    <!-- Generated by `./gradlew refreshVersions` to avoid errors when using _ as a version. -->\n    <issue id=\"GradlePluginVersion\" severity=\"ignore\" />\n    <issue id=\"GradleDependency\" severity=\"ignore\" />\n</lint>", (Object)CollectionsKt.emptyList());
        }
        try {
            boolean $i$a$-runCatching-LintUpdaterKt$attemptGettingLintXmlWithMissingRules$document$22 = false;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String string2 = lintXmlContent;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $i$a$-runCatching-LintUpdaterKt$attemptGettingLintXmlWithMissingRules$document$22 = Result.constructor-impl((Object)documentBuilder.parse(new ByteArrayInputStream(byArray)));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-LintUpdaterKt$attemptGettingLintXmlWithMissingRules$document$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-LintUpdaterKt$attemptGettingLintXmlWithMissingRules$document$22);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            return TuplesKt.to(null, (Object)CollectionsKt.listOf(LintUpdaterKt.attemptGettingLintXmlWithMissingRules$nonFatalError(lintFile, new LintUpdatingIssue.ParsingFailure(it, null, 2, null))));
        }
        Object object = $i$a$-runCatching-LintUpdaterKt$attemptGettingLintXmlWithMissingRules$document$22;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runCatching {\n        Do\u2026e(throwable = it)))\n    }");
        Document document = (Document)object;
        if (!Intrinsics.areEqual((Object)document.getDocumentElement().getTagName(), (Object)"lint")) {
            return TuplesKt.to(null, (Object)CollectionsKt.listOf(LintUpdaterKt.attemptGettingLintXmlWithMissingRules$nonFatalError(lintFile, new LintUpdatingIssue.ParsingFailure(null, "Couldn't find the root tag named \"lint\"", 1, null))));
        }
        Ref.ObjectRef problems = new Ref.ObjectRef();
        problems.element = CollectionsKt.emptyList();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"document.documentElement.childNodes");
        List<Node> nodes = NodeListKt.asList(nodeList);
        Node agpErrorSuppressNodeOrNull = LintUpdaterKt.attemptGettingLintXmlWithMissingRules$findSuppressNode(nodes, (Ref.ObjectRef<List<Problem<LintUpdatingIssue>>>)problems, lintFile, "GradlePluginVersion");
        Node libsVersionsWarningSuppressNode = LintUpdaterKt.attemptGettingLintXmlWithMissingRules$findSuppressNode(nodes, (Ref.ObjectRef<List<Problem<LintUpdatingIssue>>>)problems, lintFile, "GradleDependency");
        if (agpErrorSuppressNodeOrNull != null && libsVersionsWarningSuppressNode != null) {
            return TuplesKt.to(null, (Object)problems.element);
        }
        StringBuilder $this$attemptGettingLintXmlWithMissingRules_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String commentText = "Generated by `./gradlew refreshVersions` to avoid errors when using _ as a version.";
        String firstPart = StringKt.substringUpTo$default(lintXmlContent, "<lint>", null, 2, null);
        String secondPart = StringsKt.substringAfter$default((String)lintXmlContent, (String)"<lint>", null, (int)2, null);
        $this$attemptGettingLintXmlWithMissingRules_u24lambda_u245.append(firstPart);
        Intrinsics.checkNotNullExpressionValue((Object)$this$attemptGettingLintXmlWithMissingRules_u24lambda_u245.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = $this$attemptGettingLintXmlWithMissingRules_u24lambda_u245.append("    <!-- " + commentText + " -->");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        if (agpErrorSuppressNodeOrNull == null) {
            $this$attemptGettingLintXmlWithMissingRules_u24lambda_u245.append("    <issue id=\"GradlePluginVersion\" severity=\"ignore\" />");
        }
        if (libsVersionsWarningSuppressNode == null) {
            if (agpErrorSuppressNodeOrNull == null) {
                Intrinsics.checkNotNullExpressionValue((Object)$this$attemptGettingLintXmlWithMissingRules_u24lambda_u245.append('\n'), (String)"append(...)");
            }
            $this$attemptGettingLintXmlWithMissingRules_u24lambda_u245.append("    <issue id=\"GradleDependency\" severity=\"ignore\" />");
        }
        $this$attemptGettingLintXmlWithMissingRules_u24lambda_u245.append(secondPart);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String newLintXmlFile = string3;
        return TuplesKt.to((Object)newLintXmlFile, (Object)problems.element);
    }

    public static /* synthetic */ Pair attemptGettingLintXmlWithMissingRules$default(File file, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            if (file == null) {
                throw new IllegalStateException("Need lintFile or lintXmlContent to be set".toString());
            }
            string2 = file.exists() ? FilesKt.readText$default((File)file, null, (int)1, null) : "";
        }
        return LintUpdaterKt.attemptGettingLintXmlWithMissingRules(file, string2);
    }

    private static final boolean isIssue(Element $this$isIssue, String id) {
        return Intrinsics.areEqual((Object)$this$isIssue.getTagName(), (Object)"issue") && LintUpdaterKt.hasAttribute($this$isIssue, "id", id);
    }

    private static final boolean hasAttribute(Element $this$hasAttribute, String name, String expectedValue) {
        Node it = $this$hasAttribute.getAttributes().getNamedItem(name);
        boolean bl = false;
        return it != null && Intrinsics.areEqual((Object)expectedValue, (Object)it.getNodeValue());
    }

    private static final Problem<LintUpdatingIssue> attemptGettingLintXmlWithMissingRules$nonFatalError(File $lintFile, LintUpdatingIssue issue) {
        return new Problem<LintUpdatingIssue>(Problem.Level.Error.Companion, issue, null, $lintFile, 4, null);
    }

    private static final Node attemptGettingLintXmlWithMissingRules$findSuppressNode(List<? extends Node> nodes, Ref.ObjectRef<List<Problem<LintUpdatingIssue>>> problems, File $lintFile, String issueId) {
        Node node;
        Object v0;
        block5: {
            Iterable $this$firstOrNull$iv = nodes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                if (!(it instanceof Element && LintUpdaterKt.isIssue((Element)it, issueId))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Node node2 = v0;
        if (node2 != null) {
            Node node3;
            Node it = node3 = node2;
            boolean bl = false;
            if (!(it instanceof Element)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            if (!LintUpdaterKt.hasAttribute((Element)it, "severity", "ignore")) {
                Node node4 = ((Element)it).getAttributes().getNamedItem("severity");
                problems.element = CollectionsKt.plus((Collection)((Collection)problems.element), new Problem(Problem.Level.Warning.INSTANCE, new LintUpdatingIssue.UnexpectedSeverity(issueId, node4 != null ? node4.getNodeValue() : null), null, $lintFile, 4, null));
            }
            node = node3;
        } else {
            node = null;
        }
        return node;
    }
}

