/*
 * Decompiled with CFR 0.152.
 */
package de.fayard.refreshVersions.core.internal;

import de.fayard.refreshVersions.core.Version;
import de.fayard.refreshVersions.core.extensions.text.CharSequenceKt;
import de.fayard.refreshVersions.core.internal.OutputFile;
import de.fayard.refreshVersions.core.internal.PluginWithVersionCandidates;
import de.fayard.refreshVersions.core.internal.TaggedRange;
import de.fayard.refreshVersions.core.internal.codeparsing.SourceCodeSection;
import de.fayard.refreshVersions.core.internal.codeparsing.gradle.GradleScriptParsingKt;
import de.fayard.refreshVersions.core.internal.codeparsing.gradle.PluginBlocksLocatingKt;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0002\b\u0012J2\u0010\u0013\u001a\u00020\u0004*\u00060\u0014j\u0002`\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0015\u0010\u0018\u001a\u00020\u0004*\u00060\u0014j\u0002`\u0015H\u0000\u00a2\u0006\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lde/fayard/refreshVersions/core/internal/SettingsPluginsUpdater;", "", "()V", "updateGradleSettingsWithAvailablePluginsUpdates", "", "rootProjectSettingsFile", "Ljava/io/File;", "buildSrcSettingsFile", "settingsPluginsUpdates", "", "Lde/fayard/refreshVersions/core/internal/PluginWithVersionCandidates;", "buildSrcSettingsPluginsUpdates", "settingsFile", "updatedGradleSettingsFileContentWithAvailablePluginsUpdates", "", "fileContent", "isKotlinDsl", "", "updatedGradleSettingsFileContentWithAvailablePluginsUpdates$refreshVersions_core", "insertAvailableVersionComments", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pluginBlockRange", "Lde/fayard/refreshVersions/core/internal/TaggedRange;", "removeCommentsAddedByUs", "removeCommentsAddedByUs$refreshVersions_core", "PluginIdRegexes", "refreshVersions-core"})
@SourceDebugExtension(value={"SMAP\nSettingsPluginsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsPluginsUpdater.kt\nde/fayard/refreshVersions/core/internal/SettingsPluginsUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1855#2,2:178\n1194#2,2:180\n1222#2,4:182\n1855#2:186\n1855#2,2:187\n1856#2:189\n1#3:190\n*S KotlinDebug\n*F\n+ 1 SettingsPluginsUpdater.kt\nde/fayard/refreshVersions/core/internal/SettingsPluginsUpdater\n*L\n61#1:178,2\n79#1:180,2\n79#1:182,4\n85#1:186\n117#1:187,2\n85#1:189\n*E\n"})
public final class SettingsPluginsUpdater {
    @NotNull
    public static final SettingsPluginsUpdater INSTANCE = new SettingsPluginsUpdater();

    private SettingsPluginsUpdater() {
    }

    public final void updateGradleSettingsWithAvailablePluginsUpdates(@NotNull File rootProjectSettingsFile, @Nullable File buildSrcSettingsFile, @NotNull List<PluginWithVersionCandidates> settingsPluginsUpdates, @NotNull List<PluginWithVersionCandidates> buildSrcSettingsPluginsUpdates) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rootProjectSettingsFile, (String)"rootProjectSettingsFile");
            Intrinsics.checkNotNullParameter(settingsPluginsUpdates, (String)"settingsPluginsUpdates");
            Intrinsics.checkNotNullParameter(buildSrcSettingsPluginsUpdates, (String)"buildSrcSettingsPluginsUpdates");
            this.updateGradleSettingsWithAvailablePluginsUpdates(rootProjectSettingsFile, settingsPluginsUpdates);
            File file = buildSrcSettingsFile;
            if (file == null) break block0;
            File it = file;
            boolean bl = false;
            INSTANCE.updateGradleSettingsWithAvailablePluginsUpdates(it, buildSrcSettingsPluginsUpdates);
        }
    }

    private final void updateGradleSettingsWithAvailablePluginsUpdates(File settingsFile, List<PluginWithVersionCandidates> settingsPluginsUpdates) {
        if (!(Intrinsics.areEqual((Object)settingsFile.getName(), (Object)"settings.gradle") || Intrinsics.areEqual((Object)settingsFile.getName(), (Object)"settings.gradle.kts"))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String oldContent = FilesKt.readText$default((File)settingsFile, null, (int)1, null);
        String string3 = settingsFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"settingsFile.name");
        boolean isKotlinDsl = StringsKt.endsWith$default((String)string3, (String)".kts", (boolean)false, (int)2, null);
        String newContent = this.updatedGradleSettingsFileContentWithAvailablePluginsUpdates$refreshVersions_core(oldContent, isKotlinDsl, settingsPluginsUpdates);
        if (!Intrinsics.areEqual((Object)oldContent, (Object)newContent)) {
            FilesKt.writeText$default((File)settingsFile, (String)newContent, null, (int)2, null);
            OutputFile.logFileWasModified$default(isKotlinDsl ? OutputFile.SETTINGS_GRADLE_KTS : OutputFile.SETTINGS_GRADLE, false, 1, null);
        }
    }

    @NotNull
    public final String updatedGradleSettingsFileContentWithAvailablePluginsUpdates$refreshVersions_core(@NotNull String fileContent, boolean isKotlinDsl, @NotNull List<PluginWithVersionCandidates> settingsPluginsUpdates) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter(settingsPluginsUpdates, (String)"settingsPluginsUpdates");
        StringBuilder $this$updatedGradleSettingsFileContentWithAvailablePluginsUpdates_u24lambda_u241 = stringBuilder = new StringBuilder(fileContent.length());
        boolean bl = false;
        $this$updatedGradleSettingsFileContentWithAvailablePluginsUpdates_u24lambda_u241.append(fileContent);
        INSTANCE.removeCommentsAddedByUs$refreshVersions_core($this$updatedGradleSettingsFileContentWithAvailablePluginsUpdates_u24lambda_u241);
        StringBuilder fileContentWithoutOurComments = stringBuilder;
        List<TaggedRange<SourceCodeSection>> ranges = GradleScriptParsingKt.extractGradleScriptSections(fileContentWithoutOurComments, isKotlinDsl);
        Iterable $this$forEach$iv = CollectionsKt.asReversed(PluginBlocksLocatingKt.findPluginBlocksRanges(fileContentWithoutOurComments, ranges));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaggedRange pluginBlockRange = (TaggedRange)element$iv;
            boolean bl2 = false;
            INSTANCE.insertAvailableVersionComments(fileContentWithoutOurComments, pluginBlockRange, isKotlinDsl, settingsPluginsUpdates);
        }
        String string2 = fileContentWithoutOurComments.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileContentWithoutOurComments.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final void insertAvailableVersionComments(StringBuilder $this$insertAvailableVersionComments, TaggedRange<?> pluginBlockRange, boolean isKotlinDsl, List<PluginWithVersionCandidates> settingsPluginsUpdates) {
        void $this$associateByTo$iv$iv;
        Regex pluginIdRegex = isKotlinDsl ? PluginIdRegexes.INSTANCE.getKotlinDsl() : PluginIdRegexes.INSTANCE.getGroovyDsl();
        Iterable $this$associateBy$iv = settingsPluginsUpdates;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PluginWithVersionCandidates pluginWithVersionCandidates = (PluginWithVersionCandidates)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getPluginId(), element$iv$iv);
        }
        Map pluginsUpdatesMap = destination$iv$iv;
        StringBuilder text = $this$insertAvailableVersionComments;
        String string2 = $this$insertAvailableVersionComments.substring(0, pluginBlockRange.getEndIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.substring(0, pluginBlockRange.endIndex)");
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)pluginIdRegex.findAll((CharSequence)string2, pluginBlockRange.getStartIndex())));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String availableVersionsComments;
            MatchGroup versionCallClosingParenthesisGroup;
            MatchGroup currentVersionGroup;
            PluginWithVersionCandidates pluginWithVersionCandidates;
            MatchGroup idGroup;
            MatchResult result2 = (MatchResult)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)result2.getGroups().get(1));
            Intrinsics.checkNotNull((Object)result2.getGroups().get(2));
            Intrinsics.checkNotNull((Object)result2.getGroups().get(3));
            String pluginId = idGroup.getValue();
            if ((PluginWithVersionCandidates)pluginsUpdatesMap.get(pluginId) == null || pluginWithVersionCandidates.getVersionsCandidates().isEmpty()) continue;
            int currentVersionStartIndex = currentVersionGroup.getRange().getFirst();
            int currentVersionEndIndex = currentVersionGroup.getRange().getLast();
            int indexOfPreviousNewLine = CharSequenceKt.indexOfPrevious($this$insertAvailableVersionComments, '\n', currentVersionStartIndex);
            int indexOfNextNewLine = StringsKt.indexOf$default((CharSequence)$this$insertAvailableVersionComments, (char)'\n', (int)currentVersionEndIndex, (boolean)false, (int)4, null);
            MatchGroup it = versionCallClosingParenthesisGroup;
            boolean bl2 = false;
            boolean shouldAddClosingParenthesis = ((CharSequence)it.getValue()).length() > 0 && it.getRange().getFirst() < indexOfNextNewLine;
            int offsetOfCurrentVersionFromLineStart = currentVersionStartIndex - indexOfPreviousNewLine;
            StringBuilder $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246 = bl2 = new StringBuilder();
            boolean bl3 = false;
            int padding = offsetOfCurrentVersionFromLineStart - 8;
            Iterable $this$forEach$iv2 = pluginWithVersionCandidates.getVersionsCandidates();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Version versionCandidate = (Version)element$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append('\n'), (String)"append(...)");
                $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append("//// ");
                $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append(StringsKt.padStart$default((String)"# available", (int)RangesKt.coerceAtLeast((int)padding, (int)0), (char)'\u0000', (int)2, null));
                $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append(':');
                char stringLiteralDelimiter = text.charAt(currentVersionEndIndex + 1);
                $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append(stringLiteralDelimiter);
                $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append(versionCandidate.getValue());
                $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append(stringLiteralDelimiter);
                if (!shouldAddClosingParenthesis) continue;
                $this$insertAvailableVersionComments_u24lambda_u247_u24lambda_u246.append(versionCallClosingParenthesisGroup.getValue());
            }
            Intrinsics.checkNotNullExpressionValue((Object)bl2.toString(), (String)"toString(...)");
            $this$insertAvailableVersionComments.insert(indexOfNextNewLine, availableVersionsComments);
            int currentVersionPadding = 19 - offsetOfCurrentVersionFromLineStart;
            if (currentVersionPadding <= 0) continue;
            $this$insertAvailableVersionComments.insert(currentVersionStartIndex - 1, StringsKt.padStart$default((String)"", (int)currentVersionPadding, (char)'\u0000', (int)2, null));
        }
    }

    public final void removeCommentsAddedByUs$refreshVersions_core(@NotNull StringBuilder $this$removeCommentsAddedByUs) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCommentsAddedByUs, (String)"<this>");
        String startOfRefreshVersionsCommentLines = "\n////";
        int startIndex = 0;
        int indexOfComment;
        while ((indexOfComment = StringsKt.indexOf$default((CharSequence)$this$removeCommentsAddedByUs, (String)startOfRefreshVersionsCommentLines, (int)startIndex, (boolean)false, (int)4, null)) != -1) {
            Integer indexOfEndOfLine;
            startIndex = indexOfComment;
            Integer n = StringsKt.indexOf$default((CharSequence)$this$removeCommentsAddedByUs, (char)'\n', (int)(indexOfComment + startOfRefreshVersionsCommentLines.length()), (boolean)false, (int)4, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = indexOfEndOfLine = it >= 0 ? n : null;
            int endIndex = n2 != null ? n2.intValue() : $this$removeCommentsAddedByUs.length();
            int commentContentStartIndex = indexOfComment + startOfRefreshVersionsCommentLines.length();
            String commentContent = $this$removeCommentsAddedByUs.substring(commentContentStartIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)commentContent, (String)"commentContent");
            if (!StringsKt.contains$default((CharSequence)commentContent, (CharSequence)"# available", (boolean)false, (int)2, null)) {
                startIndex = endIndex;
                continue;
            }
            $this$removeCommentsAddedByUs.replace(indexOfComment, endIndex, "");
        }
        return;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/fayard/refreshVersions/core/internal/SettingsPluginsUpdater$PluginIdRegexes;", "", "()V", "groovyDsl", "Lkotlin/text/Regex;", "getGroovyDsl", "()Lkotlin/text/Regex;", "groovyStringLiteralPattern", "", "kotlinDsl", "getKotlinDsl", "kotlinStringLiteralPattern", "refreshVersions-core"})
    private static final class PluginIdRegexes {
        @NotNull
        public static final PluginIdRegexes INSTANCE = new PluginIdRegexes();
        @NotNull
        private static final String kotlinStringLiteralPattern = "\\\"([0-9a-zA-Z\\-\\_.]*)\\\"";
        @NotNull
        private static final String groovyStringLiteralPattern = "[\\\"']([0-9a-zA-Z\\-\\_.]*)[\\\"']";
        @NotNull
        private static final Regex kotlinDsl = new Regex("id\\s*\\(\\s*\\\"([0-9a-zA-Z\\-\\_.]*)\\\"\\s*\\)\\s*\\.?\\s*version\\s*\\(?\\s*\\\"([0-9a-zA-Z\\-\\_.]*)\\\"\\s*(\\)?)");
        @NotNull
        private static final Regex groovyDsl = new Regex("id\\s*\\(?\\s*[\\\"']([0-9a-zA-Z\\-\\_.]*)[\\\"']\\s*\\)?\\s*\\.?\\s*version\\s*\\(?\\s*[\\\"']([0-9a-zA-Z\\-\\_.]*)[\\\"']\\s*(\\)?)");

        private PluginIdRegexes() {
        }

        @NotNull
        public final Regex getKotlinDsl() {
            return kotlinDsl;
        }

        @NotNull
        public final Regex getGroovyDsl() {
            return groovyDsl;
        }
    }
}

