/*
 * Decompiled with CFR 0.152.
 */
package org.scannotation;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.scannotation.archiveiterator.Filter;
import org.scannotation.archiveiterator.IteratorFactory;
import org.scannotation.archiveiterator.StreamIterator;

public class AnnotationDB
implements Serializable {
    protected Map<String, Set<String>> annotationIndex = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> implementsIndex = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> classIndex = new HashMap<String, Set<String>>();
    protected transient boolean scanClassAnnotations = true;
    protected transient boolean scanMethodAnnotations = true;
    protected transient boolean scanParameterAnnotations = true;
    protected transient boolean scanFieldAnnotations = true;
    protected transient String[] ignoredPackages = new String[]{"javax", "java", "sun", "com.sun", "javassist"};
    protected transient String[] scanPackages = null;
    protected transient boolean ignoreBadURLs = false;

    public String[] getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(String[] scanPackages) {
        this.scanPackages = scanPackages;
    }

    public String[] getIgnoredPackages() {
        return this.ignoredPackages;
    }

    public void setIgnoredPackages(String[] ignoredPackages) {
        this.ignoredPackages = ignoredPackages;
    }

    public void addIgnoredPackages(String ... ignored) {
        String[] tmp = new String[this.ignoredPackages.length + ignored.length];
        int i = 0;
        for (String ign : this.ignoredPackages) {
            tmp[i++] = ign;
        }
        for (String ign : ignored) {
            tmp[i++] = ign;
        }
        this.ignoredPackages = tmp;
    }

    public void crossReferenceMetaAnnotations() throws CrossReferenceException {
        HashSet<String> unresolved = new HashSet<String>();
        HashSet<String> index = new HashSet<String>();
        index.addAll(this.annotationIndex.keySet());
        for (String annotation : index) {
            if (this.ignoreScan(annotation)) continue;
            if (this.classIndex.containsKey(annotation)) {
                for (String xref : this.classIndex.get(annotation)) {
                    this.annotationIndex.get(xref).addAll((Collection<String>)this.annotationIndex.get(annotation));
                }
                continue;
            }
            InputStream bits = Thread.currentThread().getContextClassLoader().getResourceAsStream(annotation.replace('.', '/') + ".class");
            if (bits == null) {
                unresolved.add(annotation);
                continue;
            }
            try {
                this.scanClass(bits);
            }
            catch (IOException e) {
                unresolved.add(annotation);
            }
            for (String xref : this.classIndex.get(annotation)) {
                this.annotationIndex.get(xref).addAll((Collection<String>)this.annotationIndex.get(annotation));
            }
        }
        if (unresolved.size() > 0) {
            throw new CrossReferenceException(unresolved);
        }
    }

    public void crossReferenceImplementedInterfaces() throws CrossReferenceException {
        HashSet<String> unresolved = new HashSet<String>();
        for (String clazz : this.implementsIndex.keySet()) {
            Set<String> intfs = this.implementsIndex.get(clazz);
            for (String intf : intfs) {
                if (this.ignoreScan(intf)) continue;
                Set<String> xrefAnnotations = this.classIndex.get(intf);
                if (xrefAnnotations == null) {
                    unresolved.add(intf);
                    continue;
                }
                Set<String> classAnnotations = this.classIndex.get(clazz);
                if (classAnnotations == null) {
                    this.classIndex.put(clazz, xrefAnnotations);
                } else {
                    classAnnotations.addAll(xrefAnnotations);
                }
                for (String annotation : xrefAnnotations) {
                    Set<String> classes = this.annotationIndex.get(annotation);
                    classes.add(clazz);
                }
            }
        }
        if (unresolved.size() > 0) {
            throw new CrossReferenceException(unresolved);
        }
    }

    private boolean ignoreScan(String intf) {
        if (this.scanPackages != null) {
            for (String scan : this.scanPackages) {
                if (!intf.startsWith(scan + ".")) continue;
                return false;
            }
            return true;
        }
        for (String ignored : this.ignoredPackages) {
            if (!intf.startsWith(ignored + ".")) continue;
            return true;
        }
        return false;
    }

    public Map<String, Set<String>> getAnnotationIndex() {
        return this.annotationIndex;
    }

    public Map<String, Set<String>> getClassIndex() {
        return this.classIndex;
    }

    public void setScanClassAnnotations(boolean scanClassAnnotations) {
        this.scanClassAnnotations = scanClassAnnotations;
    }

    public void setScanMethodAnnotations(boolean scanMethodAnnotations) {
        this.scanMethodAnnotations = scanMethodAnnotations;
    }

    public void setScanParameterAnnotations(boolean scanParameterAnnotations) {
        this.scanParameterAnnotations = scanParameterAnnotations;
    }

    public void setScanFieldAnnotations(boolean scanFieldAnnotations) {
        this.scanFieldAnnotations = scanFieldAnnotations;
    }

    public void setIgnoreBadURLs(boolean ignoreBadURLs) {
        this.ignoreBadURLs = ignoreBadURLs;
    }

    public void scanArchives(URL ... urls) throws IOException {
        for (URL url : urls) {
            Filter filter = new Filter(){

                @Override
                public boolean accepts(String filename) {
                    if (filename.endsWith(".class")) {
                        if (filename.startsWith("/") || filename.startsWith("\\")) {
                            filename = filename.substring(1);
                        }
                        if (!AnnotationDB.this.ignoreScan(filename.replace('/', '.'))) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            try {
                InputStream stream;
                StreamIterator it = IteratorFactory.create(url, filter);
                while ((stream = it.next()) != null) {
                    this.scanClass(stream);
                }
            }
            catch (IOException e) {
                if (this.ignoreBadURLs) continue;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanClass(InputStream bits) throws IOException {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(bits));
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
            this.classIndex.put(cf.getName(), new HashSet());
            if (this.scanClassAnnotations) {
                this.scanClass(cf);
            }
            if (this.scanMethodAnnotations || this.scanParameterAnnotations) {
                this.scanMethods(cf);
            }
            if (this.scanFieldAnnotations) {
                this.scanFields(cf);
            }
            if (cf.getInterfaces() != null) {
                HashSet<String> intfs = new HashSet<String>();
                for (String intf : cf.getInterfaces()) {
                    intfs.add(intf);
                }
                this.implementsIndex.put(cf.getName(), intfs);
            }
        }
        finally {
            dstream.close();
            bits.close();
        }
    }

    protected void scanClass(ClassFile cf) {
        String className = cf.getName();
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        if (visible != null) {
            this.populate(visible.getAnnotations(), className);
        }
        if (invisible != null) {
            this.populate(invisible.getAnnotations(), className);
        }
    }

    protected void scanMethods(ClassFile cf) {
        List methods = cf.getMethods();
        if (methods == null) {
            return;
        }
        for (Object obj : methods) {
            MethodInfo method = (MethodInfo)obj;
            if (this.scanMethodAnnotations) {
                AnnotationsAttribute visible = (AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations");
                AnnotationsAttribute invisible = (AnnotationsAttribute)method.getAttribute("RuntimeInvisibleAnnotations");
                if (visible != null) {
                    this.populate(visible.getAnnotations(), cf.getName());
                }
                if (invisible != null) {
                    this.populate(invisible.getAnnotations(), cf.getName());
                }
            }
            if (!this.scanParameterAnnotations) continue;
            ParameterAnnotationsAttribute paramsVisible = (ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations");
            ParameterAnnotationsAttribute paramsInvisible = (ParameterAnnotationsAttribute)method.getAttribute("RuntimeInvisibleParameterAnnotations");
            if (paramsVisible != null && paramsVisible.getAnnotations() != null) {
                for (Annotation[] anns : paramsVisible.getAnnotations()) {
                    this.populate(anns, cf.getName());
                }
            }
            if (paramsInvisible == null || paramsInvisible.getAnnotations() == null) continue;
            for (Annotation[] anns : paramsInvisible.getAnnotations()) {
                this.populate(anns, cf.getName());
            }
        }
    }

    protected void scanFields(ClassFile cf) {
        List fields = cf.getFields();
        if (fields == null) {
            return;
        }
        for (Object obj : fields) {
            FieldInfo field = (FieldInfo)obj;
            AnnotationsAttribute visible = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
            AnnotationsAttribute invisible = (AnnotationsAttribute)field.getAttribute("RuntimeInvisibleAnnotations");
            if (visible != null) {
                this.populate(visible.getAnnotations(), cf.getName());
            }
            if (invisible == null) continue;
            this.populate(invisible.getAnnotations(), cf.getName());
        }
    }

    protected void populate(Annotation[] annotations, String className) {
        if (annotations == null) {
            return;
        }
        Set<String> classAnnotations = this.classIndex.get(className);
        for (Annotation ann : annotations) {
            Set<String> classes = this.annotationIndex.get(ann.getTypeName());
            if (classes == null) {
                classes = new HashSet<String>();
                this.annotationIndex.put(ann.getTypeName(), classes);
            }
            classes.add(className);
            classAnnotations.add(ann.getTypeName());
        }
    }

    public void outputAnnotationIndex(PrintWriter writer) {
        for (String ann : this.annotationIndex.keySet()) {
            writer.print(ann);
            writer.print(": ");
            Set<String> classes = this.annotationIndex.get(ann);
            Iterator<String> it = classes.iterator();
            while (it.hasNext()) {
                writer.print(it.next());
                if (!it.hasNext()) continue;
                writer.print(", ");
            }
            writer.println();
        }
    }

    public class CrossReferenceException
    extends Exception {
        private Set<String> unresolved;

        public CrossReferenceException(Set<String> unresolved) {
            this.unresolved = unresolved;
        }

        public Set<String> getUnresolved() {
            return this.unresolved;
        }
    }
}

