/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.P2Unit;
import javax.annotation.Nullable;

class MavenCentralMapping {
    static final String MIRROR = "eclipse.maven.central.mirror";
    private static final String DASH_SNAPSHOT = "-SNAPSHOT";
    private static final String PLATFORM = "org.eclipse.platform";
    private static final String JDT = "org.eclipse.jdt";
    private static final String PDE = "org.eclipse.pde";
    private static final String EMF = "org.eclipse.emf";
    private static final String ECF = "org.eclipse.ecf";
    private static final String OSGI = "org.osgi";

    MavenCentralMapping() {
    }

    @Nullable
    static String getMavenCentralCoord(P2Unit unit) {
        String groupArtifact;
        String groupId = unit.properties.get("maven-groupId");
        String artifactId = unit.properties.get("maven-artifactId");
        String version = unit.properties.get("maven-version");
        if (groupId != null && artifactId != null && version != null && (groupArtifact = MavenCentralMapping.groupIdArtifactId(unit.id)) != null) {
            if (version.endsWith(DASH_SNAPSHOT)) {
                version = version.substring(0, version.length() - DASH_SNAPSHOT.length());
            }
            return groupArtifact + ":" + version;
        }
        return null;
    }

    private static String groupIdArtifactId(String bundleId) {
        if (bundleId.endsWith(".feature")) {
            return null;
        }
        if (bundleId.endsWith("feature.jar")) {
            return null;
        }
        if (bundleId.endsWith(".source")) {
            return null;
        }
        if ("org.eclipse.jdt.core.compiler.batch".equals(bundleId)) {
            return "org.eclipse.jdt:ecj";
        }
        if (bundleId.startsWith(JDT)) {
            return "org.eclipse.jdt:" + bundleId;
        }
        if (bundleId.startsWith(PDE)) {
            return "org.eclipse.pde:" + bundleId;
        }
        if (bundleId.startsWith(EMF)) {
            if (bundleId.equals("org.eclipse.emf.databinding.edit")) {
                return null;
            }
            return "org.eclipse.emf:" + bundleId;
        }
        if (bundleId.startsWith(ECF)) {
            return "org.eclipse.ecf:" + bundleId;
        }
        if (bundleId.startsWith(OSGI)) {
            return "org.osgi:" + bundleId;
        }
        if (bundleId.startsWith("org.eclipse.ant") || bundleId.startsWith("org.eclipse.core") || bundleId.startsWith("org.eclipse.compare") || bundleId.startsWith("org.eclipse.debug") || bundleId.startsWith("org.eclipse.e4") || bundleId.startsWith("org.eclipse.equinox") || bundleId.startsWith("org.eclipse.help") || bundleId.startsWith("org.eclipse.jface") || bundleId.startsWith("org.eclipse.jsch") || bundleId.startsWith("org.eclipse.ltk") || bundleId.startsWith("org.eclipse.osgi") || bundleId.startsWith(PLATFORM) || bundleId.startsWith("org.eclipse.rcp") || bundleId.startsWith("org.eclipse.search") || bundleId.startsWith("org.eclipse.swt") || bundleId.startsWith("org.eclipse.team") || bundleId.startsWith("org.eclipse.text") || bundleId.startsWith("org.eclipse.update") || bundleId.startsWith("org.eclipse.urischeme") || bundleId.startsWith("org.eclipse.ui")) {
            return "org.eclipse.platform:" + bundleId;
        }
        return null;
    }
}

