/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.listener;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import java.util.List;

@Experimental
public class ChatLanguageModelRequest {
    private final String model;
    private final Double temperature;
    private final Double topP;
    private final Integer maxTokens;
    private final List<ChatMessage> messages;
    private final List<ToolSpecification> toolSpecifications;

    public ChatLanguageModelRequest(String model, Double temperature, Double topP, Integer maxTokens, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        this.model = model;
        this.temperature = temperature;
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.messages = Utils.copyIfNotNull(messages);
        this.toolSpecifications = Utils.copyIfNotNull(toolSpecifications);
    }

    public String model() {
        return this.model;
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Integer maxTokens() {
        return this.maxTokens;
    }

    public List<ChatMessage> messages() {
        return this.messages;
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public static ChatLanguageModelRequestBuilder builder() {
        return new ChatLanguageModelRequestBuilder();
    }

    public static class ChatLanguageModelRequestBuilder {
        private String model;
        private Double temperature;
        private Double topP;
        private Integer maxTokens;
        private List<ChatMessage> messages;
        private List<ToolSpecification> toolSpecifications;

        ChatLanguageModelRequestBuilder() {
        }

        public ChatLanguageModelRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatLanguageModelRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ChatLanguageModelRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ChatLanguageModelRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public ChatLanguageModelRequestBuilder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public ChatLanguageModelRequestBuilder toolSpecifications(List<ToolSpecification> toolSpecifications) {
            this.toolSpecifications = toolSpecifications;
            return this;
        }

        public ChatLanguageModelRequest build() {
            return new ChatLanguageModelRequest(this.model, this.temperature, this.topP, this.maxTokens, this.messages, this.toolSpecifications);
        }

        public String toString() {
            return "ChatLanguageModelRequest.ChatLanguageModelRequestBuilder(model=" + this.model + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxTokens=" + this.maxTokens + ", messages=" + this.messages + ", toolSpecifications=" + this.toolSpecifications + ")";
        }
    }
}

