/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.internal.boot.BundleStats;
import org.eclipse.core.internal.boot.ClassloaderStats;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;
import org.eclipse.core.internal.boot.PlatformClassLoader;
import org.eclipse.core.internal.boot.URLContentFilter;
import org.eclipse.core.internal.plugins.FragmentDescriptor;
import org.eclipse.core.internal.plugins.PluginClassLoader;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PluginStats;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;

public class PluginDescriptor
extends PluginDescriptorModel
implements IPluginDescriptor {
    private DelegatingURLClassLoader loader = null;
    private boolean active = false;
    private boolean activePending = false;
    private boolean deactivated = false;
    protected Plugin pluginObject = null;
    private boolean usePlatformURLs = true;
    private ResourceBundle bundle = null;
    private Locale locale = null;
    private boolean bundleNotFound = false;
    private Object[] cachedClasspath = null;
    static final String PLUGIN_URL = "platform:/plugin/";
    static final String VERSION_SEPARATOR = "_";
    private static final String DEFAULT_BUNDLE_NAME = "plugin";
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String URL_PROTOCOL_FILE = "file";
    private static String[] WS_JAR_VARIANTS = PluginDescriptor.buildWSVariants();
    private static String[] OS_JAR_VARIANTS = PluginDescriptor.buildOSVariants();
    private static String[] NL_JAR_VARIANTS = PluginDescriptor.buildNLVariants(BootLoader.getNL());
    private static String[] JAR_VARIANTS = PluginDescriptor.buildVanillaVariants();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static String[] buildWSVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + BootLoader.getWS());
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildOSVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("os/" + BootLoader.getOS() + "/" + BootLoader.getOSArch());
        result.add("os/" + BootLoader.getOS());
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        Path base = new Path("nl");
        IPath path = new Path(nl.replace('_', '/'));
        while (path.segmentCount() > 0) {
            result.add(base.append(path).toString());
            if (path.segmentCount() > 1) {
                result.add(base.append(path.toString().replace('/', '_')).toString());
            }
            path = path.removeLastSegments(1);
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildVanillaVariants() {
        return new String[]{""};
    }

    private String[] buildBasePaths(String pluginBase) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(pluginBase);
        PluginFragmentModel[] fragments = this.getFragments();
        int fragmentLength = fragments == null ? 0 : fragments.length;
        int i = 0;
        while (i < fragmentLength) {
            FragmentDescriptor fragment = (FragmentDescriptor)fragments[i];
            result.add(fragment.getInstallURL().toString());
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private String concat(String start, String end) {
        if (end == null) {
            return null;
        }
        if (end.startsWith("..")) {
            return null;
        }
        if (end.startsWith("./")) {
            return String.valueOf(start) + end.substring(2);
        }
        if (end.startsWith(".")) {
            return String.valueOf(start) + end.substring(1);
        }
        return String.valueOf(start) + end;
    }

    public Object createExecutableExtension(String className, Object initData, IConfigurationElement cfig, String propertyName) throws CoreException {
        Class<?> classInstance = null;
        try {
            classInstance = this.getPluginClassLoader(true).loadClass(className);
        }
        catch (Exception e1) {
            this.throwException(Policy.bind("plugin.loadClassError", this.getId(), className), e1);
        }
        Object result = null;
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e) {
            this.throwException(Policy.bind("plugin.instantiateClassError", this.getId(), className), e);
        }
        if (result instanceof IExecutableExtension) {
            try {
                ((IExecutableExtension)result).setInitializationData(cfig, propertyName, initData);
            }
            catch (CoreException ce) {
                this.logError(ce.getStatus());
                throw new CoreException(ce.getStatus());
            }
            catch (Exception te) {
                this.throwException(Policy.bind("policy.initObjectError", this.getId(), className), te);
            }
        }
        return result;
    }

    Object createExecutableExtension(String pluginName, String className, Object initData, IConfigurationElement cfig, String propertyName) throws CoreException {
        String id = this.getUniqueIdentifier();
        if (pluginName != null && !pluginName.equals("") && !pluginName.equals(id)) {
            PluginDescriptor plugin = null;
            plugin = (PluginDescriptor)this.getPluginRegistry().getPluginDescriptor(pluginName);
            return plugin.createExecutableExtension(className, initData, cfig, propertyName);
        }
        return this.createExecutableExtension(className, initData, cfig, propertyName);
    }

    synchronized void doPluginActivation() throws CoreException {
        block5: {
            boolean errorExit = true;
            if (!this.pluginActivationEnter()) break block5;
            try {
                if (DelegatingURLClassLoader.MONITOR_PLUGINS) {
                    PluginStats.startActivation(this.getUniqueIdentifier());
                }
                this.internalDoPluginActivation();
                errorExit = false;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.pluginActivationExit(errorExit);
                if (DelegatingURLClassLoader.MONITOR_PLUGINS) {
                    PluginStats.endActivation(this.getUniqueIdentifier());
                }
                throw throwable;
            }
            Object var2_4 = null;
            this.pluginActivationExit(errorExit);
            if (DelegatingURLClassLoader.MONITOR_PLUGINS) {
                PluginStats.endActivation(this.getUniqueIdentifier());
            }
        }
    }

    synchronized void doPluginDeactivation() {
        this.loader = null;
        this.pluginObject = null;
        this.active = false;
        this.activePending = false;
        this.deactivated = false;
    }

    private static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[0]);
    }

    public IExtension getExtension(String id) {
        if (id == null) {
            return null;
        }
        ExtensionModel[] list = this.getDeclaredExtensions();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (id.equals(list[i].getId())) {
                return (IExtension)((Object)list[i]);
            }
            ++i;
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String extensionPointId) {
        if (extensionPointId == null) {
            return null;
        }
        ExtensionPointModel[] list = this.getDeclaredExtensionPoints();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (extensionPointId.equals(list[i].getId())) {
                return (IExtensionPoint)((Object)list[i]);
            }
            ++i;
        }
        return null;
    }

    public IExtensionPoint[] getExtensionPoints() {
        ExtensionPointModel[] list = this.getDeclaredExtensionPoints();
        if (list == null) {
            return new IExtensionPoint[0];
        }
        IExtensionPoint[] newValues = new IExtensionPoint[list.length];
        System.arraycopy(list, 0, newValues, 0, list.length);
        return newValues;
    }

    public IExtension[] getExtensions() {
        ExtensionModel[] list = this.getDeclaredExtensions();
        if (list == null) {
            return new IExtension[0];
        }
        IExtension[] newValues = new IExtension[list.length];
        System.arraycopy(list, 0, newValues, 0, list.length);
        return newValues;
    }

    public URL getInstallURL() {
        try {
            return new URL(PLUGIN_URL + this.toString() + "/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException();
        }
    }

    public URL getInstallURLInternal() {
        String url = this.getLocation();
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException();
        }
    }

    public String getLabel() {
        String s = this.getName();
        return s == null ? "" : this.getResourceString(s);
    }

    public Plugin getPlugin() throws CoreException {
        if (this.pluginObject == null) {
            this.doPluginActivation();
        }
        return this.pluginObject;
    }

    public ClassLoader getPluginClassLoader() {
        return this.getPluginClassLoader(true);
    }

    public ClassLoader getPluginClassLoader(boolean eclipseURLs) {
        if (this.loader != null) {
            return this.loader;
        }
        Object[] path = this.getPluginClassLoaderPath(eclipseURLs);
        URL[] codePath = (URL[])path[0];
        URLContentFilter[] codeFilters = (URLContentFilter[])path[1];
        URL[] resourcePath = (URL[])path[2];
        URLContentFilter[] resourceFilters = (URLContentFilter[])path[3];
        this.loader = new PluginClassLoader(codePath, codeFilters, resourcePath, resourceFilters, PlatformClassLoader.getDefault().getParent(), this);
        this.loader.initializeImportedLoaders();
        return this.loader;
    }

    private Object[] getPluginClassLoaderPath(boolean platformURLFlag) {
        if (this.cachedClasspath != null) {
            return this.cachedClasspath;
        }
        this.usePlatformURLs = platformURLFlag;
        URL install = this.usePlatformURLs ? this.getInstallURL() : this.getInstallURLInternal();
        String execBase = install.toExternalForm();
        String[] basePaths = this.buildBasePaths(execBase);
        String[] exportAll = new String[]{"*"};
        ArrayList[] result = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        if (DelegatingURLClassLoader.devClassPath != null) {
            String[] specs = PluginDescriptor.getArrayFromList(DelegatingURLClassLoader.devClassPath);
            Vector<String> baseSpecs = new Vector<String>(specs.length);
            int j = 0;
            while (j < specs.length) {
                String spec = specs[j];
                char lastChar = spec.charAt(spec.length() - 1);
                if (!spec.endsWith(".jar") && lastChar != '/' && lastChar != '\\') {
                    spec = String.valueOf(spec) + "/";
                }
                if (!spec.endsWith(".jar")) {
                    baseSpecs.add(spec);
                }
                this.addLibraryWithFragments(basePaths, JAR_VARIANTS, spec, exportAll, "code", true, result);
                ++j;
            }
            String[] baseSuffix = baseSpecs.toArray(new String[baseSpecs.size()]);
            String[] newBasePaths = new String[basePaths.length + basePaths.length * baseSpecs.size()];
            int newIdx = 0;
            int j2 = 0;
            while (j2 < baseSuffix.length) {
                int i = 0;
                while (i < basePaths.length) {
                    newBasePaths[newIdx++] = String.valueOf(basePaths[i]) + baseSuffix[j2];
                    ++i;
                }
                ++j2;
            }
            int i = 0;
            while (i < basePaths.length) {
                newBasePaths[newIdx++] = basePaths[i];
                ++i;
            }
            basePaths = newBasePaths;
        }
        ILibrary[] list = this.getRuntimeLibraries();
        int i = 0;
        while (i < list.length) {
            ILibrary library = list[i];
            if (!library.getPath().isEmpty()) {
                String[] filters = library.isFullyExported() ? exportAll : library.getContentFilters();
                String libSpec = library.getPath().toString();
                this.resolveAndAddLibrary(libSpec, filters, basePaths, library.getType(), result);
            }
            ++i;
        }
        Object[] array = new Object[]{result[0].toArray(new URL[result[0].size()]), result[1].toArray(new URLContentFilter[result[1].size()]), result[2].toArray(new URL[result[2].size()]), result[3].toArray(new URLContentFilter[result[3].size()])};
        this.cachedClasspath = array;
        return array;
    }

    private boolean resolveAndAddLibrary(String spec, String[] filters, String[] basePaths, String type, ArrayList[] result) {
        if (spec.charAt(0) == '$') {
            Path path = new Path(spec);
            String first = path.segment(0);
            String remainder = path.removeFirstSegments(1).toString();
            if (first.equalsIgnoreCase("$ws$")) {
                return this.addLibraryWithFragments(basePaths, WS_JAR_VARIANTS, "/" + remainder, filters, type, false, result);
            }
            if (first.equalsIgnoreCase("$os$")) {
                return this.addLibraryWithFragments(basePaths, OS_JAR_VARIANTS, "/" + remainder, filters, type, false, result);
            }
            if (first.equalsIgnoreCase("$nl$")) {
                return this.addLibraryWithFragments(basePaths, NL_JAR_VARIANTS, "/" + remainder, filters, type, false, result);
            }
        }
        return this.addLibraryWithFragments(basePaths, JAR_VARIANTS, spec, filters, type, false, result);
    }

    private boolean addLibraryWithFragments(String[] basePaths, String[] variants, String spec, String[] filters, String type, boolean addAll, ArrayList[] result) {
        boolean added = false;
        int j = 0;
        while (j < variants.length && (addAll || !added)) {
            int i = 0;
            while (i < basePaths.length && (addAll || !added)) {
                added = this.addLibrary(basePaths[i], spec, variants[j], filters, type, result);
                ++i;
            }
            ++j;
        }
        return added;
    }

    private boolean addLibrary(String base, String libSpec, String variant, String[] filters, String type, ArrayList[] result) {
        String spec = null;
        spec = variant.length() == 0 && libSpec.startsWith("/") && base.endsWith("/") ? this.concat(base, libSpec.substring(1)) : this.concat(this.concat(base, variant), libSpec);
        if (spec == null) {
            return false;
        }
        if (!spec.endsWith("/")) {
            spec = spec.startsWith("platform:") ? String.valueOf(spec) + "!/" : "jar:" + spec + "!/";
        }
        try {
            URL entry = new URL(spec);
            URL resolved = Platform.resolve(entry);
            boolean add = true;
            String file = this.getFileFromURL(resolved);
            if (file != null) {
                add = new File(file).exists();
            }
            if (add) {
                if (type.equals("code")) {
                    result[0].add(resolved);
                    result[1].add(new URLContentFilter(filters));
                } else if (type.equals("resource")) {
                    result[2].add(resolved);
                    result[3].add(new URLContentFilter(filters));
                }
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public String getFileFromURL(URL target) {
        String protocol = target.getProtocol();
        if (protocol.equals(URL_PROTOCOL_FILE)) {
            return target.getFile();
        }
        if (protocol.equals("jar")) {
            String file = target.getFile();
            file = file.substring(0, file.length() - "!/".length());
            try {
                return this.getFileFromURL(new URL(file));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public IPluginPrerequisite[] getPluginPrerequisites() {
        PluginPrerequisiteModel[] list = this.getRequires();
        if (list == null) {
            return new IPluginPrerequisite[0];
        }
        IPluginPrerequisite[] newValues = new IPluginPrerequisite[list.length];
        System.arraycopy(list, 0, newValues, 0, list.length);
        return newValues;
    }

    public PluginRegistry getPluginRegistry() {
        return (PluginRegistry)this.getRegistry();
    }

    public String getProviderName() {
        String s = super.getProviderName();
        return s == null ? "" : this.getResourceString(s);
    }

    public ResourceBundle getResourceBundle() throws MissingResourceException {
        return this.getResourceBundle(Locale.getDefault());
    }

    public ResourceBundle getResourceBundle(Locale targetLocale) throws MissingResourceException {
        if (this.bundle != null && targetLocale.equals(this.locale)) {
            return this.bundle;
        }
        if (this.bundleNotFound) {
            throw new MissingResourceException(Policy.bind("plugin.bundleNotFound", this.getId(), "plugin_" + targetLocale), "plugin_" + targetLocale, "");
        }
        URL[] cp = (URL[])this.getPluginClassLoaderPath(true)[0];
        URL[] newcp = new URL[cp.length + 1];
        int i = 0;
        while (i < cp.length) {
            newcp[i + 1] = cp[i];
            ++i;
        }
        try {
            newcp[0] = Platform.resolve(this.getInstallURL());
        }
        catch (IOException iOException) {
            newcp[0] = this.getInstallURL();
        }
        URLClassLoader resourceLoader = new URLClassLoader(newcp, null);
        ResourceBundle newBundle = null;
        try {
            newBundle = ResourceBundle.getBundle(DEFAULT_BUNDLE_NAME, targetLocale, resourceLoader);
            if (DelegatingURLClassLoader.MONITOR_BUNDLES) {
                ClassloaderStats.loadedBundle((String)this.getUniqueIdentifier(), (BundleStats)new BundleStats(this.getUniqueIdentifier(), "plugin.properties", newBundle));
            }
            this.bundle = newBundle;
            this.locale = targetLocale;
        }
        catch (MissingResourceException e) {
            this.bundleNotFound = true;
            throw e;
        }
        return newBundle;
    }

    public String getResourceString(String value) {
        return this.getResourceString(value, null);
    }

    public String getResourceString(String value, ResourceBundle b) {
        String dflt;
        String s = value.trim();
        if (!s.startsWith(KEY_PREFIX)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX)) {
            return s.substring(1);
        }
        int ix = s.indexOf(" ");
        String key = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (b == null) {
            try {
                b = this.getResourceBundle();
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (b == null) {
            return dflt;
        }
        try {
            return b.getString(key.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return dflt;
        }
    }

    public ILibrary[] getRuntimeLibraries() {
        LibraryModel[] list = this.getRuntime();
        if (list == null) {
            return new ILibrary[0];
        }
        ILibrary[] newValues = new ILibrary[list.length];
        System.arraycopy(list, 0, newValues, 0, list.length);
        return newValues;
    }

    public String getUniqueIdentifier() {
        return this.getId();
    }

    public static String getUniqueIdentifierFromString(String pluginString) {
        int ix = pluginString.indexOf(VERSION_SEPARATOR);
        return ix == -1 ? pluginString : pluginString.substring(0, ix);
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        String version = this.getVersion();
        if (version == null) {
            return new PluginVersionIdentifier("1.0.0");
        }
        try {
            return new PluginVersionIdentifier(version);
        }
        catch (Exception exception) {
            return new PluginVersionIdentifier("1.0.0");
        }
    }

    public static PluginVersionIdentifier getVersionIdentifierFromString(String pluginString) {
        int ix = pluginString.indexOf(VERSION_SEPARATOR);
        if (ix == -1) {
            return null;
        }
        String vid = pluginString.substring(ix + 1);
        try {
            return new PluginVersionIdentifier(vid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IPluginPrerequisite[] getPluginResolvedPrerequisites() {
        PluginPrerequisiteModel[] prereqs = this.getRequires();
        if (prereqs == null || prereqs.length == 0) {
            return new IPluginPrerequisite[0];
        }
        ArrayList<PluginPrerequisiteModel> resolvedPrerequisites = new ArrayList<PluginPrerequisiteModel>(prereqs.length);
        int i = 0;
        while (i < prereqs.length) {
            String prereqId;
            if (prereqs[i].getResolvedVersion() != null && !(prereqId = prereqs[i].getPlugin()).equalsIgnoreCase("org.eclipse.core.runtime") && !prereqId.equalsIgnoreCase("org.eclipse.core.boot")) {
                resolvedPrerequisites.add(prereqs[i]);
            }
            ++i;
        }
        if (resolvedPrerequisites.isEmpty()) {
            return new IPluginPrerequisite[0];
        }
        return resolvedPrerequisites.toArray(new IPluginPrerequisite[resolvedPrerequisites.size()]);
    }

    private void internalDoPluginActivation() throws CoreException {
        String errorMsg;
        Class<?> runtimeClass;
        String pluginClassName;
        block18: {
            pluginClassName = this.getPluginClass();
            runtimeClass = null;
            try {
                if (pluginClassName == null || pluginClassName.equals("")) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.internal.plugins.DefaultPlugin");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    runtimeClass = clazz;
                    break block18;
                }
                runtimeClass = this.getPluginClassLoader(true).loadClass(pluginClassName);
            }
            catch (ClassNotFoundException e) {
                errorMsg = Policy.bind("plugin.loadClassError", this.getId(), pluginClassName);
                this.throwException(errorMsg, e);
            }
        }
        Constructor<?> construct = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.runtime.IPluginDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            construct = runtimeClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException eNoConstructor) {
            errorMsg = Policy.bind("plugin.instantiateClassError", this.getId(), pluginClassName);
            this.throwException(errorMsg, eNoConstructor);
        }
        long time = 0L;
        if (InternalPlatform.DEBUG_STARTUP) {
            time = System.currentTimeMillis();
            System.out.println("Starting plugin: " + this.getId());
        }
        try {
            this.pluginObject = (Plugin)construct.newInstance(this);
        }
        catch (ClassCastException e) {
            errorMsg = Policy.bind("plugin.notPluginClass", pluginClassName);
            this.throwException(errorMsg, e);
        }
        catch (Exception e) {
            errorMsg = Policy.bind("plugin.instantiateClassError", this.getId(), pluginClassName);
            this.throwException(errorMsg, e);
        }
        final String message = Policy.bind("plugin.startupProblems", this.getId());
        final MultiStatus multiStatus = new MultiStatus("org.eclipse.core.runtime", 2, message, null);
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                PluginDescriptor.this.pluginObject.startup();
            }

            public void handleException(Throwable e) {
                multiStatus.add(new Status(2, "org.eclipse.core.runtime", 2, message, e));
                try {
                    PluginDescriptor.this.pluginObject.shutdown();
                }
                catch (Exception exception) {}
            }
        };
        InternalPlatform.run(code);
        if (InternalPlatform.DEBUG_STARTUP) {
            time = System.currentTimeMillis() - time;
            System.out.println("Finished plugin startup for " + this.getId() + " time: " + time + "ms");
        }
        if (!multiStatus.isOK()) {
            throw new CoreException(multiStatus);
        }
    }

    public synchronized boolean isPluginActivated() {
        return this.active;
    }

    public synchronized boolean isPluginDeactivated() {
        return this.deactivated;
    }

    private void logError(IStatus status) {
        InternalPlatform.getRuntimePlugin().getLog().log(status);
        if (InternalPlatform.DEBUG) {
            System.out.println(status.getMessage());
        }
    }

    private boolean pluginActivationEnter() throws CoreException {
        if (this.deactivated) {
            String errorMsg = Policy.bind("plugin.pluginDisabled", this.getId());
            this.throwException(errorMsg, null);
        }
        if (this.active || this.activePending) {
            return false;
        }
        this.activePending = true;
        return true;
    }

    private void pluginActivationExit(boolean errorExit) {
        this.activePending = false;
        if (errorExit) {
            this.active = false;
            this.deactivated = true;
        } else {
            this.active = true;
        }
    }

    private String getFragmentLocation(PluginFragmentModel fragment) {
        if (this.usePlatformURLs) {
            return "platform:/fragment/" + fragment.toString() + "/";
        }
        return fragment.getLocation();
    }

    public void setPluginClassLoader(DelegatingURLClassLoader value) {
        this.loader = value;
    }

    public void setPluginClassLoader(PluginClassLoader value) {
        this.loader = value;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.core.runtime", 2, message, exception);
        this.logError(status);
        throw new CoreException(status);
    }

    public String toString() {
        return String.valueOf(this.getUniqueIdentifier()) + VERSION_SEPARATOR + this.getVersionIdentifier().toString();
    }

    public void activateDefaultPlugins(DelegatingURLClassLoader loader) {
        Object[] result = this.getPluginClassLoaderPath(true);
        loader.addURLs((URL[])result[0], (URLContentFilter[])result[1], (URL[])result[2], (URLContentFilter[])result[3]);
    }

    public final URL find(IPath path) {
        return this.find(path, null);
    }

    public final URL find(IPath path, Map override) {
        if (path == null) {
            return null;
        }
        URL install = this.getInstallURLInternal();
        URL result = null;
        if (path.isEmpty() || path.isRoot()) {
            result = this.findInPlugin(install, Path.EMPTY);
            if (result == null) {
                result = this.findInFragments(Path.EMPTY);
            }
            return result;
        }
        String first = path.segment(0);
        if (first.charAt(0) != '$') {
            result = this.findInPlugin(install, path);
            if (result == null) {
                result = this.findInFragments(path);
            }
            return result;
        }
        IPath rest = path.removeFirstSegments(1);
        if (first.equalsIgnoreCase("$nl$")) {
            return this.findNL(install, rest, override);
        }
        if (first.equalsIgnoreCase("$os$")) {
            return this.findOS(install, rest, override);
        }
        if (first.equalsIgnoreCase("$ws$")) {
            return this.findWS(install, rest, override);
        }
        if (first.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private URL findOS(URL install, IPath path, Map override) {
        String os = null;
        if (override != null) {
            try {
                os = (String)override.get("$os$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (os == null) {
            os = BootLoader.getOS();
        }
        if (os.length() == 0) {
            return null;
        }
        String osArch = null;
        if (override != null) {
            try {
                osArch = (String)override.get("$arch$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (osArch == null) {
            osArch = BootLoader.getOSArch();
        }
        if (osArch.length() == 0) {
            return null;
        }
        URL result = null;
        IPath base = new Path("os").append(os).append(osArch);
        while (base.segmentCount() != 1) {
            IPath filePath = base.append(path);
            result = this.findInPlugin(install, filePath);
            if (result != null) {
                return result;
            }
            result = this.findInFragments(filePath);
            if (result != null) {
                return result;
            }
            base = base.removeLastSegments(1);
        }
        result = this.findInPlugin(install, path);
        if (result != null) {
            return result;
        }
        return this.findInFragments(path);
    }

    private URL findWS(URL install, IPath path, Map override) {
        IPath filePath;
        URL result;
        String ws = null;
        if (override != null) {
            try {
                ws = (String)override.get("$ws$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (ws == null) {
            ws = BootLoader.getWS();
        }
        if ((result = this.findInPlugin(install, filePath = new Path("ws").append(ws).append(path))) != null) {
            return result;
        }
        result = this.findInFragments(filePath);
        if (result != null) {
            return result;
        }
        result = this.findInPlugin(install, path);
        if (result != null) {
            return result;
        }
        return this.findInFragments(path);
    }

    private URL findNL(URL install, IPath path, Map override) {
        String nl = null;
        String[] nlVariants = null;
        if (override != null) {
            try {
                nl = (String)override.get("$nl$");
            }
            catch (ClassCastException classCastException) {}
        }
        String[] stringArray = nlVariants = nl == null ? NL_JAR_VARIANTS : PluginDescriptor.buildNLVariants(nl);
        if (nl != null && nl.length() == 0) {
            return null;
        }
        URL result = null;
        int i = 0;
        while (i < nlVariants.length) {
            IPath filePath = new Path(nlVariants[i]).append(path);
            result = this.findInPlugin(install, filePath);
            if (result != null) {
                return result;
            }
            result = this.findInFragments(filePath);
            if (result != null) {
                return result;
            }
            ++i;
        }
        result = this.findInPlugin(install, path);
        if (result != null) {
            return result;
        }
        return this.findInFragments(path);
    }

    private URL findInPlugin(URL install, IPath filePath) {
        try {
            Path foundPath;
            Path pluginRootPath;
            URL location = new URL(install, filePath.toString());
            String file = this.getFileFromURL(location);
            if (file != null && new File(file).exists() && (pluginRootPath = new Path(install.getFile())).isPrefixOf(foundPath = new Path(file))) {
                return location;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private URL findInFragments(IPath filePath) {
        PluginFragmentModel[] fragments = this.getFragments();
        if (fragments == null) {
            return null;
        }
        int i = 0;
        while (i < fragments.length) {
            try {
                Path foundPath;
                Path fragmentRootPath;
                URL fragmentRootURL = new URL(fragments[i].getLocation());
                URL location = new URL(fragmentRootURL, filePath.toString());
                String file = this.getFileFromURL(location);
                if (file != null && new File(file).exists() && (fragmentRootPath = new Path(fragmentRootURL.getFile())).isPrefixOf(foundPath = new Path(file))) {
                    return location;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        return null;
    }
}

