/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

public class Log
implements ILog {
    Plugin plugin;
    Set logListeners = new HashSet(5);

    Log(Plugin plugin) {
        this.plugin = plugin;
    }

    public void addLogListener(ILogListener listener) {
        Set set = this.logListeners;
        synchronized (set) {
            this.logListeners.add(listener);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void log(final IStatus status) {
        ILogListener[] listeners;
        InternalPlatform.log(status);
        Set set = this.logListeners;
        synchronized (set) {
            listeners = this.logListeners.toArray(new ILogListener[this.logListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final ILogListener listener = listeners[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.logging(status, Log.this.plugin.getDescriptor().getUniqueIdentifier());
                }

                public void handleException(Throwable e) {
                }
            };
            InternalPlatform.run(code);
            ++i;
        }
    }

    public void removeLogListener(ILogListener listener) {
        Set set = this.logListeners;
        synchronized (set) {
            this.logListeners.remove(listener);
        }
    }
}

