/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public class PlatformURLFragmentConnection
extends PlatformURLConnection {
    private PluginFragmentModel fd = null;
    private static boolean isRegistered = false;
    public static final String FRAGMENT = "fragment";
    static /* synthetic */ Class class$0;

    public PlatformURLFragmentConnection(URL url) {
        super(url);
    }

    protected boolean allowCaching() {
        return true;
    }

    protected URL resolve() throws IOException {
        String spec = ((URLConnection)((Object)this)).url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith(FRAGMENT)) {
            throw new IOException(Policy.bind("url.badVariant", ((URLConnection)((Object)this)).url.toString()));
        }
        int ix = spec.indexOf("/", FRAGMENT.length() + 1);
        String ref = ix == -1 ? spec.substring(FRAGMENT.length() + 1) : spec.substring(FRAGMENT.length() + 1, ix);
        String id = this.getId(ref);
        String vid = this.getVersion(ref);
        PluginRegistryModel registry = (PluginRegistryModel)((Object)Platform.getPluginRegistry());
        PluginFragmentModel pluginFragmentModel = this.fd = vid == null ? registry.getFragment(id) : registry.getFragment(id, vid);
        if (this.fd == null) {
            throw new IOException(Policy.bind("url.resolveFragment", ((URLConnection)((Object)this)).url.toString()));
        }
        URL result = new URL(this.fd.getLocation());
        if (ix == -1 || ix + 1 >= spec.length()) {
            return result;
        }
        return new URL(result, spec.substring(ix + 1));
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.runtime.PlatformURLFragmentConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register((String)FRAGMENT, (Class)clazz);
        isRegistered = true;
    }
}

