/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.SelectableAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public abstract class FlexibleAdapter<VH extends RecyclerView.ViewHolder, T>
extends SelectableAdapter<VH> {
    private static final String TAG = FlexibleAdapter.class.getSimpleName();
    public static final long UNDO_TIMEOUT = 5000L;
    private final Object mLock = new Object();
    protected List<T> mItems;
    protected List<T> mDeletedItems;
    protected List<Integer> mOriginalPosition;
    protected static String mSearchText;
    protected OnUpdateListener mUpdateListener;
    protected Handler mHandler;

    public FlexibleAdapter() {
    }

    public FlexibleAdapter(Object listener) {
        if (listener instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listener;
        } else {
            Log.w((String)TAG, (String)"Listener is not an instance of OnUpdateListener!");
        }
    }

    public void updateDataSet() {
        this.updateDataSet(null);
    }

    public abstract void updateDataSet(String var1);

    public void updateDataSetAsync(String param) {
        if (this.mUpdateListener == null) {
            Log.w((String)TAG, (String)"OnUpdateListener is not initialized. updateDataSetAsync is not using FilterAsyncTask!");
            this.updateDataSet(param);
            this.notifyDataSetChanged();
            return;
        }
        new FilterAsyncTask().execute(new String[]{param});
    }

    public T getItem(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public int getPositionForItem(T item) {
        return this.mItems != null && this.mItems.size() > 0 ? this.mItems.indexOf(item) : -1;
    }

    public boolean contains(T item) {
        return this.mItems != null && this.mItems.contains(item);
    }

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    public abstract void onBindViewHolder(VH var1, int var2);

    public int getItemCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateItem(int position, T item) {
        if (position < 0) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mItems.set(position, item);
        }
        Log.v((String)TAG, (String)("updateItem notifyItemChanged on position " + position));
        this.notifyItemChanged(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(int position, T item) {
        if (position < 0) {
            return;
        }
        if (position < this.mItems.size()) {
            Log.v((String)TAG, (String)("addItem notifyItemInserted on position " + position));
            Object object = this.mLock;
            synchronized (object) {
                this.mItems.add(position, item);
            }
        }
        Log.v((String)TAG, (String)"addItem notifyItemInserted on last position");
        Object object = this.mLock;
        synchronized (object) {
            this.mItems.add(item);
            position = this.mItems.size();
        }
        this.notifyItemInserted(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(int position) {
        if (position < 0) {
            return;
        }
        if (position < this.mItems.size()) {
            Log.v((String)TAG, (String)("removeItem notifyItemRemoved on position " + position));
            Object object = this.mLock;
            synchronized (object) {
                this.saveDeletedItem(position, this.mItems.remove(position));
            }
            this.notifyItemRemoved(position);
        } else {
            Log.w((String)TAG, (String)"removeItem WARNING! Position OutOfBound! Review the position to remove!");
        }
    }

    public void removeItems(List<Integer> selectedPositions) {
        Log.v((String)TAG, (String)"removeItems reverse Sorting positions --------------");
        Collections.sort(selectedPositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                return rhs - lhs;
            }
        });
        while (!selectedPositions.isEmpty()) {
            if (selectedPositions.size() == 1) {
                this.removeItem(selectedPositions.get(0));
                selectedPositions.remove(0);
            } else {
                int count;
                for (count = 1; selectedPositions.size() > count && selectedPositions.get(count).equals(selectedPositions.get(count - 1) - 1); ++count) {
                }
                if (count == 1) {
                    this.removeItem(selectedPositions.get(0));
                } else {
                    this.removeRange(selectedPositions.get(count - 1), count);
                }
                for (int i = 0; i < count; ++i) {
                    selectedPositions.remove(0);
                }
            }
            Log.v((String)TAG, (String)("removeItems current selection " + this.getSelectedItems()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRange(int positionStart, int itemCount) {
        Log.v((String)TAG, (String)("removeRange positionStart=" + positionStart + " itemCount=" + itemCount));
        for (int i = 0; i < itemCount; ++i) {
            Object object = this.mLock;
            synchronized (object) {
                this.saveDeletedItem(positionStart, this.mItems.remove(positionStart));
                continue;
            }
        }
        Log.v((String)TAG, (String)"removeRange notifyItemRangeRemoved");
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    public void saveDeletedItem(int position, T item) {
        if (this.mDeletedItems == null) {
            this.mDeletedItems = new ArrayList<T>();
            this.mOriginalPosition = new ArrayList<Integer>();
        }
        Log.v((String)TAG, (String)("Recycled " + this.getItem(position) + " on position=" + position));
        this.mDeletedItems.add(item);
        this.mOriginalPosition.add(position);
    }

    public List<T> getDeletedItems() {
        return this.mDeletedItems;
    }

    public boolean isRestoreInTime() {
        return this.mDeletedItems != null && this.mDeletedItems.size() > 0;
    }

    public void restoreDeletedItems() {
        this.stopUndoTimer();
        for (int i = this.mOriginalPosition.size() - 1; i >= 0; --i) {
            T item = this.mDeletedItems.get(i);
            if (FlexibleAdapter.hasSearchText() && !this.filterObject(item, FlexibleAdapter.getSearchText())) continue;
            this.addItem(this.mOriginalPosition.get(i), item);
        }
        this.emptyBin();
    }

    public synchronized void emptyBin() {
        if (this.mDeletedItems != null) {
            this.mDeletedItems.clear();
            this.mOriginalPosition.clear();
        }
    }

    public void startUndoTimer() {
        this.startUndoTimer(0L);
    }

    public void startUndoTimer(long timeout) {
        this.mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (FlexibleAdapter.this.mUpdateListener != null) {
                    FlexibleAdapter.this.mUpdateListener.onDeleteConfirmed();
                }
                FlexibleAdapter.this.emptyBin();
                return true;
            }
        });
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler), timeout > 0L ? timeout : 5000L);
    }

    private void stopUndoTimer() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
    }

    public static boolean hasSearchText() {
        return mSearchText != null && mSearchText.length() > 0;
    }

    public static String getSearchText() {
        return mSearchText;
    }

    public static void setSearchText(String searchText) {
        mSearchText = searchText != null ? searchText.trim().toLowerCase(Locale.getDefault()) : "";
    }

    protected synchronized void filterItems(List<T> unfilteredItems) {
        if (FlexibleAdapter.hasSearchText()) {
            this.mItems = new ArrayList<T>();
            int newOriginalPosition = -1;
            int oldOriginalPosition = -1;
            for (T item : unfilteredItems) {
                if (!this.filterObject(item, FlexibleAdapter.getSearchText())) continue;
                if (this.mDeletedItems != null && this.mDeletedItems.contains(item)) {
                    int index = this.mDeletedItems.indexOf(item);
                    if (this.mOriginalPosition.get(index) != oldOriginalPosition) {
                        ++newOriginalPosition;
                        oldOriginalPosition = this.mOriginalPosition.get(index);
                    }
                    this.mOriginalPosition.set(index, newOriginalPosition + this.mItems.size());
                    continue;
                }
                this.mItems.add(item);
            }
        } else {
            this.mItems = unfilteredItems;
            if (this.mDeletedItems != null && !this.mDeletedItems.isEmpty()) {
                this.mOriginalPosition = new ArrayList<Integer>(this.mDeletedItems.size());
                for (T item : this.mDeletedItems) {
                    this.mOriginalPosition.add(this.mItems.indexOf(item));
                }
                this.mItems.removeAll(this.mDeletedItems);
            }
        }
    }

    protected boolean filterObject(T myObject, String constraint) {
        String[] words;
        String valueText = myObject.toString().toLowerCase();
        if (valueText.startsWith(constraint)) {
            return true;
        }
        for (String word : words = valueText.split(" ")) {
            if (!word.startsWith(constraint)) continue;
            return true;
        }
        return false;
    }

    public class FilterAsyncTask
    extends AsyncTask<String, Void, Void> {
        private final String TAG = FilterAsyncTask.class.getSimpleName();

        protected Void doInBackground(String ... params) {
            FlexibleAdapter.this.updateDataSet(params[0]);
            return null;
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute((Object)result);
            FlexibleAdapter.this.mUpdateListener.onLoadComplete();
            FlexibleAdapter.this.notifyDataSetChanged();
        }
    }

    public static interface OnUpdateListener {
        public void onLoadComplete();

        public void onDeleteConfirmed();
    }
}

