/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.fastscroller;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;

public class ScrollbarAnimator {
    private static final String PROPERTY_NAME = "translationX";
    protected View bar;
    protected View handle;
    protected AnimatorSet scrollbarAnimatorSet;
    protected long delayInMillis;
    protected long durationInMillis;
    private boolean isAnimating;

    public ScrollbarAnimator(View bar, View handle, long delayInMillis, long durationInMillis) {
        this.bar = bar;
        this.handle = handle;
        this.delayInMillis = delayInMillis;
        this.durationInMillis = durationInMillis;
    }

    public void setDelayInMillis(long delayInMillis) {
        this.delayInMillis = delayInMillis;
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    public void showScrollbar() {
        if (this.bar == null || this.handle == null) {
            return;
        }
        if (this.isAnimating) {
            this.scrollbarAnimatorSet.cancel();
        }
        if (this.bar.getVisibility() == 4 || this.handle.getVisibility() == 4) {
            this.bar.setVisibility(0);
            this.handle.setVisibility(0);
            this.scrollbarAnimatorSet = this.createAnimator(this.bar, this.handle, true);
            this.scrollbarAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    ScrollbarAnimator.this.onShowAnimationStop(ScrollbarAnimator.this.bar, ScrollbarAnimator.this.handle);
                    ScrollbarAnimator.this.isAnimating = false;
                }

                public void onAnimationCancel(Animator animation) {
                    super.onAnimationCancel(animation);
                    ScrollbarAnimator.this.onShowAnimationStop(ScrollbarAnimator.this.bar, ScrollbarAnimator.this.handle);
                    ScrollbarAnimator.this.isAnimating = false;
                }
            });
            this.scrollbarAnimatorSet.start();
            this.isAnimating = true;
        }
    }

    public void hideScrollbar() {
        if (this.bar == null || this.handle == null) {
            return;
        }
        if (this.isAnimating) {
            this.scrollbarAnimatorSet.cancel();
        }
        this.scrollbarAnimatorSet = this.createAnimator(this.bar, this.handle, false);
        this.scrollbarAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ScrollbarAnimator.this.onHideAnimationStop(ScrollbarAnimator.this.bar, ScrollbarAnimator.this.handle);
                ScrollbarAnimator.this.isAnimating = false;
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                ScrollbarAnimator.this.onHideAnimationStop(ScrollbarAnimator.this.bar, ScrollbarAnimator.this.handle);
                ScrollbarAnimator.this.isAnimating = false;
            }
        });
        this.scrollbarAnimatorSet.start();
        this.isAnimating = true;
    }

    protected AnimatorSet createAnimator(View bar, View handle, boolean showFlag) {
        ObjectAnimator barAnimator = ObjectAnimator.ofFloat((Object)bar, (String)PROPERTY_NAME, (float[])new float[]{showFlag ? 0.0f : (float)bar.getWidth()});
        ObjectAnimator handleAnimator = ObjectAnimator.ofFloat((Object)handle, (String)PROPERTY_NAME, (float[])new float[]{showFlag ? 0.0f : (float)handle.getWidth()});
        AnimatorSet animator = new AnimatorSet();
        animator.playTogether(new Animator[]{barAnimator, handleAnimator});
        animator.setDuration(this.durationInMillis);
        if (!showFlag) {
            animator.setStartDelay(this.delayInMillis);
        }
        return animator;
    }

    protected void onShowAnimationStop(View bar, View handle) {
    }

    protected void onHideAnimationStop(View bar, View handle) {
        bar.setVisibility(4);
        handle.setVisibility(4);
        bar.setTranslationX(0.0f);
        handle.setTranslationX(0.0f);
    }
}

