/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import eu.davidea.flexibleadapter.common.IFlexibleLayoutManager;

public class FlexibleLayoutManager
implements IFlexibleLayoutManager {
    protected RecyclerView mRecyclerView;
    protected RecyclerView.LayoutManager mLayoutManager;

    public FlexibleLayoutManager(RecyclerView recyclerView) {
        this(recyclerView.getLayoutManager());
        this.mRecyclerView = recyclerView;
    }

    public FlexibleLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mLayoutManager = layoutManager;
    }

    @Override
    public int getOrientation() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getOrientation();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getOrientation();
        }
        return 1;
    }

    @Override
    public int getSpanCount() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getSpanCount();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return 1;
    }

    @Override
    public int findFirstCompletelyVisibleItemPosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGLM = (StaggeredGridLayoutManager)layoutManager;
            int position = staggeredGLM.findFirstCompletelyVisibleItemPositions(null)[0];
            for (int i = 1; i < this.getSpanCount(); ++i) {
                int nextPosition = staggeredGLM.findFirstCompletelyVisibleItemPositions(null)[i];
                if (nextPosition >= position) continue;
                position = nextPosition;
            }
            return position;
        }
        return ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
    }

    @Override
    public int findFirstVisibleItemPosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGLM = (StaggeredGridLayoutManager)layoutManager;
            int position = staggeredGLM.findFirstVisibleItemPositions(null)[0];
            for (int i = 1; i < this.getSpanCount(); ++i) {
                int nextPosition = staggeredGLM.findFirstVisibleItemPositions(null)[i];
                if (nextPosition >= position) continue;
                position = nextPosition;
            }
            return position;
        }
        return ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
    }

    @Override
    public int findLastCompletelyVisibleItemPosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGLM = (StaggeredGridLayoutManager)layoutManager;
            int position = staggeredGLM.findLastCompletelyVisibleItemPositions(null)[0];
            for (int i = 1; i < this.getSpanCount(); ++i) {
                int nextPosition = staggeredGLM.findLastCompletelyVisibleItemPositions(null)[i];
                if (nextPosition <= position) continue;
                position = nextPosition;
            }
            return position;
        }
        return ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGLM = (StaggeredGridLayoutManager)layoutManager;
            int position = staggeredGLM.findLastVisibleItemPositions(null)[0];
            for (int i = 1; i < this.getSpanCount(); ++i) {
                int nextPosition = staggeredGLM.findLastVisibleItemPositions(null)[i];
                if (nextPosition <= position) continue;
                position = nextPosition;
            }
            return position;
        }
        return ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
    }

    private RecyclerView.LayoutManager getLayoutManager() {
        return this.mRecyclerView != null ? this.mRecyclerView.getLayoutManager() : this.mLayoutManager;
    }
}

