/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.viewholders;

import android.support.annotation.CallSuper;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.viewholders.FlexibleViewHolder;

public abstract class ExpandableViewHolder
extends FlexibleViewHolder {
    public ExpandableViewHolder(View view, FlexibleAdapter adapter) {
        super(view, adapter);
    }

    public ExpandableViewHolder(View view, FlexibleAdapter adapter, boolean stickyHeader) {
        super(view, adapter, stickyHeader);
    }

    protected boolean isViewExpandableOnClick() {
        return true;
    }

    protected boolean isViewCollapsibleOnClick() {
        return true;
    }

    protected boolean isViewCollapsibleOnLongClick() {
        return true;
    }

    protected boolean shouldNotifyParentOnClick() {
        return false;
    }

    protected void toggleExpansion() {
        int position = this.getFlexibleAdapterPosition();
        if (this.isViewCollapsibleOnClick() && this.mAdapter.isExpanded(position)) {
            this.collapseView(position);
        } else if (this.isViewExpandableOnClick() && !this.mAdapter.isSelected(position)) {
            this.expandView(position);
        }
    }

    protected void expandView(int position) {
        this.mAdapter.expand(position, this.shouldNotifyParentOnClick());
    }

    protected void collapseView(int position) {
        this.mAdapter.collapse(position, this.shouldNotifyParentOnClick());
        if (this.itemView.getX() < 0.0f || this.itemView.getY() < 0.0f) {
            this.mAdapter.getRecyclerView().scrollToPosition(position);
        }
    }

    @Override
    @CallSuper
    public void onClick(View view) {
        if (this.mAdapter.isItemEnabled(this.getFlexibleAdapterPosition())) {
            this.toggleExpansion();
        }
        super.onClick(view);
    }

    @Override
    @CallSuper
    public boolean onLongClick(View view) {
        int position = this.getFlexibleAdapterPosition();
        if (this.mAdapter.isItemEnabled(position) && this.isViewCollapsibleOnLongClick()) {
            this.collapseView(position);
        }
        return super.onLongClick(view);
    }

    @Override
    @CallSuper
    public void onActionStateChanged(int position, int actionState) {
        if (this.mAdapter.isExpanded(this.getFlexibleAdapterPosition())) {
            this.collapseView(position);
        }
        super.onActionStateChanged(position, actionState);
    }
}

