/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidationResult;

public class ZeroHashSignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    @Override
    public boolean canValidate(SignaturePolicy signaturePolicy) {
        return signaturePolicy.isZeroHash();
    }

    @Override
    public SignaturePolicyValidationResult validate(SignaturePolicy signaturePolicy) {
        SignaturePolicyValidationResult validationResult = new SignaturePolicyValidationResult();
        validationResult.setIdentified(true);
        validationResult.setDigestValid(true);
        return validationResult;
    }

    @Override
    public Digest getComputedDigest(DSSDocument policyDocument, DigestAlgorithm digestAlgorithm) {
        return new Digest(digestAlgorithm, DSSUtils.EMPTY_BYTE_ARRAY);
    }
}

