/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.DataIdentifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.validation.AdvancedSignature;
import java.util.Objects;

public class SignatureSignatureScope
extends SignatureScope {
    private final AdvancedSignature signature;

    public SignatureSignatureScope(AdvancedSignature signature, DSSDocument document) {
        super(signature.getId(), document);
        Objects.requireNonNull(signature, "Signature shall be provided!");
        this.signature = signature;
    }

    public DataIdentifier getDSSId() {
        return super.getDSSId();
    }

    public String getName(TokenIdentifierProvider tokenIdentifierProvider) {
        return this.getSignatureId(tokenIdentifierProvider);
    }

    public String getDescription(TokenIdentifierProvider tokenIdentifierProvider) {
        return String.format("Signature with Id : %s", this.getSignatureId(tokenIdentifierProvider));
    }

    private String getSignatureId(TokenIdentifierProvider tokenIdentifierProvider) {
        return tokenIdentifierProvider.getIdAsString((IdentifierBasedObject)this.signature);
    }

    public SignatureScopeType getType() {
        return SignatureScopeType.SIGNATURE;
    }
}

