/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.policy.RuleUtils;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.BasicSignatureConstraints;
import eu.europa.esig.dss.policy.jaxb.CertificateConstraints;
import eu.europa.esig.dss.policy.jaxb.CertificateValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.RevocationConstraints;
import eu.europa.esig.dss.policy.jaxb.SignatureConstraints;
import eu.europa.esig.dss.policy.jaxb.TimeConstraint;
import eu.europa.esig.dss.spi.validation.RevocationDataVerifier;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationDataVerifierFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationDataVerifier.class);
    private final ValidationPolicy validationPolicy;
    private Date validationTime;

    public RevocationDataVerifierFactory(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    protected Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    public RevocationDataVerifierFactory setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
        return this;
    }

    public RevocationDataVerifier create() {
        RevocationDataVerifier revocationDataVerifier = RevocationDataVerifier.createEmptyRevocationDataVerifier();
        this.instantiateCryptographicConstraints(revocationDataVerifier, this.validationPolicy);
        this.instantiateRevocationSkipConstraints(revocationDataVerifier, this.validationPolicy);
        this.instantiateRevocationFreshnessConstraints(revocationDataVerifier, this.validationPolicy);
        return revocationDataVerifier;
    }

    private void instantiateCryptographicConstraints(RevocationDataVerifier revocationDataVerifier, ValidationPolicy validationPolicy) {
        Map<EncryptionAlgorithm, Object> acceptableEncryptionAlgorithms;
        List<DigestAlgorithm> acceptableDigestAlgorithms;
        CryptographicConstraintWrapper constraint = this.getRevocationCryptographicConstraints(validationPolicy);
        if (constraint != null && Level.FAIL.equals((Object)constraint.getLevel())) {
            Date currentTime = this.getValidationTime();
            acceptableDigestAlgorithms = constraint.getReliableDigestAlgorithmsAtTime(currentTime);
            acceptableEncryptionAlgorithms = constraint.getReliableEncryptionAlgorithmsWithMinimalKeyLengthAtTime(currentTime);
        } else {
            LOG.info("No enforced cryptographic constraints have been found in the provided validation policy. Accept all cryptographic algorithms.");
            acceptableDigestAlgorithms = Arrays.asList(DigestAlgorithm.values());
            acceptableEncryptionAlgorithms = new EnumMap(EncryptionAlgorithm.class);
            for (EncryptionAlgorithm encryptionAlgorithm : EncryptionAlgorithm.values()) {
                acceptableEncryptionAlgorithms.put(encryptionAlgorithm, 0);
            }
        }
        revocationDataVerifier.setAcceptableDigestAlgorithms(acceptableDigestAlgorithms);
        revocationDataVerifier.setAcceptableEncryptionAlgorithmKeyLength(acceptableEncryptionAlgorithms);
    }

    private CryptographicConstraintWrapper getRevocationCryptographicConstraints(ValidationPolicy validationPolicy) {
        CryptographicConstraint cryptographicConstraint = validationPolicy.getSignatureCryptographicConstraint(Context.REVOCATION);
        return cryptographicConstraint != null ? new CryptographicConstraintWrapper(cryptographicConstraint) : null;
    }

    private void instantiateRevocationSkipConstraints(RevocationDataVerifier revocationDataVerifier, ValidationPolicy validationPolicy) {
        HashSet<String> certificateExtensions = new HashSet<String>();
        HashSet<String> certificatePolicies = new HashSet<String>();
        if (validationPolicy.getSignatureConstraints() != null) {
            this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, validationPolicy.getSignatureConstraints().getBasicSignatureConstraints());
        }
        if (validationPolicy.getCounterSignatureConstraints() != null) {
            this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, validationPolicy.getCounterSignatureConstraints().getBasicSignatureConstraints());
        }
        if (validationPolicy.getRevocationConstraints() != null) {
            this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, validationPolicy.getRevocationConstraints().getBasicSignatureConstraints());
        }
        if (validationPolicy.getTimestampConstraints() != null) {
            this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, validationPolicy.getTimestampConstraints().getBasicSignatureConstraints());
        }
        this.ensureOcspNoCheck(certificateExtensions, validationPolicy);
        revocationDataVerifier.setRevocationSkipCertificateExtensions(certificateExtensions);
        revocationDataVerifier.setRevocationSkipCertificatePolicies(certificatePolicies);
    }

    private void ensureOcspNoCheck(Set<String> certificateExtensions, ValidationPolicy validationPolicy) {
        CertificateConstraints signingCertificate;
        BasicSignatureConstraints basicSignatureConstraints;
        RevocationConstraints revocationConstraints = validationPolicy.getRevocationConstraints();
        if (revocationConstraints != null && (basicSignatureConstraints = revocationConstraints.getBasicSignatureConstraints()) != null && (signingCertificate = basicSignatureConstraints.getSigningCertificate()) != null && signingCertificate.getRevocationDataSkip() != null) {
            return;
        }
        LOG.info("No RevocationDataSkip constraint is defined in the validation policy for Revocation/SigningCertificate element! Default behavior with ocsp-no-check is added to processing. Please set the constraint explicitly. To be required since DSS 6.2.");
        certificateExtensions.add(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId());
    }

    private void populateRevocationSkipFromBasicSignatureConstraints(Set<String> certificateExtensions, Set<String> certificatePolicies, BasicSignatureConstraints basicSignatureConstraints) {
        if (basicSignatureConstraints != null) {
            this.populateRevocationSkipFromCertificateConstraints(certificateExtensions, certificatePolicies, basicSignatureConstraints.getSigningCertificate());
            this.populateRevocationSkipFromCertificateConstraints(certificateExtensions, certificatePolicies, basicSignatureConstraints.getCACertificate());
        }
    }

    private void populateRevocationSkipFromCertificateConstraints(Set<String> certificateExtensions, Set<String> certificatePolicies, CertificateConstraints certificateConstraints) {
        MultiValuesConstraint certificatePoliciesConstraint;
        if (certificateConstraints == null) {
            return;
        }
        CertificateValuesConstraint revocationDataSkipConstraint = certificateConstraints.getRevocationDataSkip();
        if (revocationDataSkipConstraint == null) {
            return;
        }
        MultiValuesConstraint certificateExtensionsConstraint = revocationDataSkipConstraint.getCertificateExtensions();
        if (certificateExtensionsConstraint != null) {
            certificateExtensions.addAll(certificateExtensionsConstraint.getId());
        }
        if ((certificatePoliciesConstraint = revocationDataSkipConstraint.getCertificatePolicies()) != null) {
            certificatePolicies.addAll(certificatePoliciesConstraint.getId());
        }
    }

    private void instantiateRevocationFreshnessConstraints(RevocationDataVerifier revocationDataVerifier, ValidationPolicy validationPolicy) {
        BasicSignatureConstraints basicSignatureConstraints;
        boolean revocationFreshnessNextUpdateConstraint = false;
        if (validationPolicy.getSignatureConstraints() != null || validationPolicy.getCounterSignatureConstraints() != null) {
            revocationDataVerifier.setSignatureMaximumRevocationFreshness(this.getSignatureRevocationFreshnessConstraint(validationPolicy));
            if (validationPolicy.getSignatureConstraints() != null) {
                revocationFreshnessNextUpdateConstraint = this.getRevocationFreshnessNextUpdateConstraint(validationPolicy.getSignatureConstraints().getBasicSignatureConstraints());
            }
            if (!revocationFreshnessNextUpdateConstraint && validationPolicy.getCounterSignatureConstraints() != null) {
                revocationFreshnessNextUpdateConstraint = this.getRevocationFreshnessNextUpdateConstraint(validationPolicy.getCounterSignatureConstraints().getBasicSignatureConstraints());
            }
        }
        if (validationPolicy.getTimestampConstraints() != null) {
            basicSignatureConstraints = validationPolicy.getTimestampConstraints().getBasicSignatureConstraints();
            revocationDataVerifier.setTimestampMaximumRevocationFreshness(this.getRevocationFreshnessConstraint(basicSignatureConstraints));
            if (!revocationFreshnessNextUpdateConstraint && validationPolicy.getTimestampConstraints() != null) {
                revocationFreshnessNextUpdateConstraint = this.getRevocationFreshnessNextUpdateConstraint(validationPolicy.getTimestampConstraints().getBasicSignatureConstraints());
            }
        }
        if (validationPolicy.getRevocationConstraints() != null) {
            basicSignatureConstraints = validationPolicy.getRevocationConstraints().getBasicSignatureConstraints();
            revocationDataVerifier.setRevocationMaximumRevocationFreshness(this.getRevocationFreshnessConstraint(basicSignatureConstraints));
            if (!revocationFreshnessNextUpdateConstraint && validationPolicy.getRevocationConstraints() != null) {
                revocationFreshnessNextUpdateConstraint = this.getRevocationFreshnessNextUpdateConstraint(validationPolicy.getRevocationConstraints().getBasicSignatureConstraints());
            }
        }
        revocationDataVerifier.setCheckRevocationFreshnessNextUpdate(revocationFreshnessNextUpdateConstraint);
    }

    private Long getSignatureRevocationFreshnessConstraint(ValidationPolicy validationPolicy) {
        SignatureConstraints counterSignatureConstraints;
        Long maximumRevocationFreshness = null;
        SignatureConstraints signatureConstraints = validationPolicy.getSignatureConstraints();
        if (signatureConstraints != null) {
            maximumRevocationFreshness = this.getRevocationFreshnessConstraint(signatureConstraints.getBasicSignatureConstraints());
        }
        if ((counterSignatureConstraints = validationPolicy.getCounterSignatureConstraints()) != null) {
            Long counterSignatureRevocationFreshnessConstraint = this.getRevocationFreshnessConstraint(counterSignatureConstraints.getBasicSignatureConstraints());
            if (maximumRevocationFreshness == null || counterSignatureRevocationFreshnessConstraint != null && counterSignatureRevocationFreshnessConstraint < maximumRevocationFreshness) {
                maximumRevocationFreshness = counterSignatureRevocationFreshnessConstraint;
            }
        }
        return maximumRevocationFreshness;
    }

    private Long getRevocationFreshnessConstraint(BasicSignatureConstraints basicSignatureConstraints) {
        Long maximumRevocationFreshness = null;
        if (basicSignatureConstraints != null) {
            CertificateConstraints caCertificateConstraints;
            CertificateConstraints signingCertificateConstraints = basicSignatureConstraints.getSigningCertificate();
            if (signingCertificateConstraints != null) {
                maximumRevocationFreshness = this.getRevocationFreshnessConstraintValue(signingCertificateConstraints);
            }
            if ((caCertificateConstraints = basicSignatureConstraints.getCACertificate()) != null) {
                Long caCertRevocationFreshness = this.getRevocationFreshnessConstraintValue(caCertificateConstraints);
                if (maximumRevocationFreshness == null || caCertRevocationFreshness != null && caCertRevocationFreshness < maximumRevocationFreshness) {
                    maximumRevocationFreshness = caCertRevocationFreshness;
                }
            }
        }
        return maximumRevocationFreshness;
    }

    private Long getRevocationFreshnessConstraintValue(CertificateConstraints certificateConstraints) {
        TimeConstraint revocationFreshness = certificateConstraints.getRevocationFreshness();
        if (revocationFreshness != null) {
            return RuleUtils.convertDuration((TimeConstraint)revocationFreshness);
        }
        return null;
    }

    private boolean getRevocationFreshnessNextUpdateConstraint(BasicSignatureConstraints basicSignatureConstraints) {
        if (basicSignatureConstraints != null) {
            CertificateConstraints signingCertificateConstraint = basicSignatureConstraints.getSigningCertificate();
            if (signingCertificateConstraint != null && signingCertificateConstraint.getRevocationFreshnessNextUpdate() != null) {
                return true;
            }
            CertificateConstraints caCertificateConstraint = basicSignatureConstraints.getCACertificate();
            if (caCertificateConstraint != null && caCertificateConstraint.getRevocationFreshnessNextUpdate() != null) {
                return true;
            }
        }
        return false;
    }
}

