/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.type;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.validation.process.qualification.certificate.QCTypeIdentifiers;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import java.util.stream.Stream;

class TypeByCertificatePostEIDAS
implements TypeStrategy {
    private final CertificateWrapper signingCertificate;

    public TypeByCertificatePostEIDAS(CertificateWrapper signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    @Override
    public CertificateType getType() {
        boolean onlyOne;
        boolean esign = QCTypeIdentifiers.isQCTypeEsign(this.signingCertificate);
        boolean eseal = QCTypeIdentifiers.isQCTypeEseal(this.signingCertificate);
        boolean web = QCTypeIdentifiers.isQCTypeWeb(this.signingCertificate);
        boolean noneType = !esign && !eseal && !web;
        boolean bl = onlyOne = Stream.of(esign, eseal, web).filter(b -> b).count() == 1L;
        if (noneType && this.signingCertificate.isQcCompliance() || esign && onlyOne) {
            return CertificateType.ESIGN;
        }
        if (eseal && onlyOne) {
            return CertificateType.ESEAL;
        }
        if (web && onlyOne) {
            return CertificateType.WSA;
        }
        return CertificateType.UNKNOWN;
    }
}

